/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.swing.graph;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import org.objectweb.util.explorer.swing.graph.Graph;
import org.objectweb.util.explorer.swing.graph.MyPort;
import org.objectweb.util.explorer.swing.graph.PortGraphicsInterface;
import org.objectweb.util.explorer.swing.graph.PrimitiveVertex;
import org.objectweb.util.explorer.swing.graph.VertexGraphicsInterface;
import org.omg.CORBA.Object;

public class CCMVertex
extends PrimitiveVertex {
    private MyPort lastPort = null;

    public CCMVertex(java.lang.Object component, String name, Graph graph, Dimension dim, boolean controllersDisplay) {
        super(component, name, graph, dim, controllersDisplay, true, false);
        this.type = "ccm";
    }

    public void addPort(java.lang.Object ref, String name, String type) {
        MyPort p = null;
        if (type == "facet") {
            ++this.numberServer;
            p = new MyPort(ref, name, type, this.numberServer, false);
            this.serverPorts.add(p);
        } else if (type == "consumer") {
            ++this.numberServer;
            p = new MyPort(ref, name, type, this.numberServer, false);
            this.serverPorts.add(p);
        } else if (type == "receptacle") {
            ++this.numberClient;
            p = new MyPort(ref, name, type, this.numberClient, false);
            this.clientPorts.add(p);
        } else if (type == "emitter") {
            ++this.numberClient;
            p = new MyPort(ref, name, type, this.numberClient, false);
            this.clientPorts.add(p);
        } else if (type == "publisher") {
            ++this.numberClient;
            p = new MyPort(ref, name, type, this.numberClient, false);
            this.clientPorts.add(p);
        } else if (type == "controler") {
            this.controllerPorts = new ArrayList();
            this.numberControler = 1;
            p = new MyPort(ref, name, type, this.numberControler, false);
            this.controllerPorts.add(p);
        }
        super.add((MutableTreeNode)((java.lang.Object)p));
        this.ports.add(p);
        this.lastPort = p;
    }

    public MyPort getLastPort() {
        return this.lastPort;
    }

    public boolean isShared() {
        return false;
    }

    public ArrayList getListPorts() {
        return this.ports;
    }

    public ArrayList getListServerPorts() {
        return this.serverPorts;
    }

    public ArrayList getListClientPorts() {
        return this.clientPorts;
    }

    public ArrayList getListControllerPorts() {
        return this.controllerPorts;
    }

    public MyPort getPort(String name) {
        for (int i = 0; i < this.ports.size(); ++i) {
            MyPort port = (MyPort)((java.lang.Object)this.ports.get(i));
            if (!port.getName().equals(name)) continue;
            return port;
        }
        return null;
    }

    public MyPort getPort(Object reference) {
        for (int i = 0; i < this.ports.size(); ++i) {
            MyPort port_ = (MyPort)((java.lang.Object)this.ports.get(i));
            if (port_.getType() == "publisher" || port_.getType() == "receptacle" || port_.getType() == "controler") {
                List lst = (List)port_.getItf();
                Iterator iter = lst.iterator();
                while (iter.hasNext()) {
                    Object pc = (Object)iter.next();
                    if (!pc._is_equivalent(reference)) continue;
                    return port_;
                }
                continue;
            }
            Object refObj = (Object)port_.getItf();
            if (!refObj._is_equivalent(reference)) continue;
            return port_;
        }
        return null;
    }

    public MyPort getPort(String name, String type) {
        ArrayList ports_ = type == "facet" || type == "consumer" ? this.getListClientPorts() : (type == "receptacle" || type == "emitter" || type == "publisher" ? this.getListServerPorts() : this.getListControllerPorts());
        for (int i = 0; i < ports_.size(); ++i) {
            if (!((MyPort)((java.lang.Object)ports_.get(i))).getName().equals(name) || ((MyPort)((java.lang.Object)ports_.get(i))).getType() != type) continue;
            return (MyPort)((java.lang.Object)ports_.get(i));
        }
        return null;
    }

    public MyPort getPort(String name, String type, int number) {
        ArrayList ports_ = type == "facet" || type == "consumer" ? this.getListClientPorts() : (type == "receptacle" || type == "emitter" || type == "publisher" ? this.getListServerPorts() : this.getListControllerPorts());
        for (int i = 0; i < ports_.size(); ++i) {
            if (!((MyPort)((java.lang.Object)ports_.get(i))).getName().equals(name) || ((MyPort)((java.lang.Object)ports_.get(i))).getNumber() != number) continue;
            return (MyPort)((java.lang.Object)ports_.get(i));
        }
        return null;
    }

    public Dimension getSize() {
        int minWidth;
        VertexGraphicsInterface vg = Graph.getVertexGraphics();
        PortGraphicsInterface pg = Graph.getPortGraphics();
        int portsServer = this.getListServerPorts().size();
        int portsClients = this.getListClientPorts().size();
        int portsControl = this.getListControllerPorts().size();
        if (this.size.height < portsServer * 14) {
            this.size.height = portsServer * 14 + 25;
        }
        if (this.size.height < portsClients * 14) {
            this.size.height = portsClients * 14 + 25;
        }
        if (this.size.width < portsControl * 30) {
            this.size.width = portsControl * 30;
        }
        if ((minWidth = this.getMinWidth()) > 3000) {
            minWidth = 3000;
        }
        if (this.size.width < minWidth) {
            this.size.width = minWidth;
        }
        if (this.size.height == 0 || this.size.height < vg.getDefaultSize().height) {
            this.size.height = vg.getDefaultSize().height;
        }
        if (this.size.width == 0 || this.size.width < vg.getDefaultSize().width) {
            this.size.width = vg.getDefaultSize().width;
        }
        return this.size;
    }
}

