/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.swing.graph;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.objectweb.util.explorer.swing.graph.CacheBounds;
import org.objectweb.util.explorer.swing.graph.Graph;
import org.objectweb.util.explorer.swing.graph.MyPort;
import org.objectweb.util.explorer.swing.graph.PortGraphicsInterface;
import org.objectweb.util.explorer.swing.graph.PrimitiveVertex;
import org.objectweb.util.explorer.swing.graph.VertexGraphicsInterface;

public class CompositeVertex
extends PrimitiveVertex {
    private boolean isOpen = false;
    private ArrayList verteces = new ArrayList();
    private Point origin;
    private ArrayList binding = new ArrayList();
    private ArrayList internalPorts;
    private ArrayList internalServerPorts;
    private ArrayList internalClientPorts;
    private ArrayList internalControllerPorts;
    private int numberInternalServer;
    private int numberInternalClient;
    private int numberInternalController;

    public CompositeVertex(Object component, String name, Graph graph, Dimension compositeSize, boolean isOpen, boolean controllersDisplay, boolean isStarted, boolean isShared) {
        super(component, name, graph, compositeSize, controllersDisplay, isStarted, isShared);
        this.setSize(compositeSize);
        this.isOpen = isOpen;
        this.type = "composite";
        if (isOpen) {
            this.verteces.add(this);
            AttributeMap vAttributes = graph.getModel().createAttributes();
            this.internalPorts = new ArrayList();
            this.internalServerPorts = new ArrayList();
            this.internalClientPorts = new ArrayList();
            this.internalControllerPorts = new ArrayList();
            this.origin = new Point();
        }
    }

    public ArrayList getBinding() {
        return this.binding;
    }

    public Edge addBinding(GraphModel model) {
        DefaultEdge e = new DefaultEdge();
        this.binding.add(e);
        AttributeMap eAttributes = model.createAttributes();
        this.attributes.put((Object)e, (Object)eAttributes);
        int style = 11;
        GraphConstants.setLineStyle((Map)eAttributes, (int)style);
        return e;
    }

    public MyPort getInternalPort(String name) {
        for (int i = 0; i < this.internalPorts.size(); ++i) {
            if (!((MyPort)((Object)this.internalPorts.get(i))).getName().equals(name) || ((MyPort)((Object)this.internalPorts.get(i))).isGenerated()) continue;
            return (MyPort)((Object)this.internalPorts.get(i));
        }
        return null;
    }

    public MyPort getGeneratedPort(String name) {
        ArrayList internalPorts = this.getListInternalPorts();
        for (int i = 0; i < internalPorts.size(); ++i) {
            if (!((MyPort)((Object)internalPorts.get(i))).getName().equals(name) || !((MyPort)((Object)internalPorts.get(i))).isGenerated()) continue;
            return (MyPort)((Object)internalPorts.get(i));
        }
        return null;
    }

    public ArrayList getListInternalPorts() {
        return this.internalPorts;
    }

    public ArrayList getListInternalServerPorts() {
        if (this.internalServerPorts.size() == 0) {
            ArrayList ports = this.getListInternalPorts();
            for (int i = 0; i < ports.size(); ++i) {
                if (!((MyPort)((Object)ports.get(i))).getType().equals("server")) continue;
                this.internalServerPorts.add(ports.get(i));
            }
        }
        return this.internalServerPorts;
    }

    public ArrayList getListInternalClientPorts() {
        if (this.internalClientPorts.size() == 0) {
            ArrayList ports = this.getListInternalPorts();
            for (int i = 0; i < ports.size(); ++i) {
                if (!((MyPort)((Object)ports.get(i))).getType().equals("client")) continue;
                this.internalClientPorts.add(ports.get(i));
            }
        }
        return this.internalClientPorts;
    }

    public ArrayList getListInternalControllerPorts() {
        if (this.internalControllerPorts.size() == 0) {
            ArrayList ports = this.getListInternalPorts();
            for (int i = 0; i < ports.size(); ++i) {
                if (!((MyPort)((Object)ports.get(i))).getType().equals("controler")) continue;
                this.internalControllerPorts.add(ports.get(i));
            }
        }
        return this.internalControllerPorts;
    }

    public PrimitiveVertex getVertex(String name) {
        for (int i = 0; i < this.verteces.size(); ++i) {
            if (!((PrimitiveVertex)((Object)this.verteces.get(i))).getName().equals(name)) continue;
            return (PrimitiveVertex)((Object)this.verteces.get(i));
        }
        return null;
    }

    public PrimitiveVertex getVertex(Object component) {
        if (component == this.getComponent()) {
            return this;
        }
        for (int i = 0; i < this.verteces.size(); ++i) {
            if (!((PrimitiveVertex)((Object)this.verteces.get(i))).getComponent().equals(component)) continue;
            return (PrimitiveVertex)((Object)this.verteces.get(i));
        }
        return null;
    }

    public void addVertex(Object component, String name, Graph graph, String type, boolean isOpen, boolean controllersDisplay, boolean isStarted, boolean isShared) {
        PrimitiveVertex vertex;
        PortGraphicsInterface pg = Graph.getPortGraphics();
        VertexGraphicsInterface vg = Graph.getVertexGraphics();
        AttributeMap vAttributes = graph.getModel().createAttributes();
        if (type.equals("primitif")) {
            PrimitiveVertex newComponent;
            vertex = newComponent = new PrimitiveVertex(component, name, graph, this.getSize(), controllersDisplay, isStarted, isShared);
            if (CacheBounds.isCached(this, newComponent)) {
                vAttributes.put((Object)"bounds", (Object)CacheBounds.getBounds(this, newComponent));
                newComponent.setAttributes(vAttributes);
            }
            this.attributes.put((Object)vertex, (Object)vAttributes);
        } else {
            CompositeVertex newComponent = new CompositeVertex(component, name, graph, vg.getDefaultSize(), isOpen, controllersDisplay, isStarted, isShared);
            vertex = newComponent;
            if (CacheBounds.isCached(this, newComponent)) {
                vAttributes.put((Object)"bounds", (Object)CacheBounds.getBounds(this, newComponent));
                newComponent.setAttributes(vAttributes);
            }
        }
        this.verteces.add(vertex);
    }

    public void addSubComponentPort(String vertexName, Object itf, String portName, String type) {
        PrimitiveVertex v = this.getVertex(vertexName);
        v.addPort(itf, portName, type);
    }

    public void addCompositePort(Object itf, String portName, String type) {
        MyPort initialPort = null;
        MyPort generatedPort = null;
        if (type.equals("client") || type.equals("collection")) {
            ++this.numberInternalClient;
            initialPort = new MyPort(itf, portName, type, this.numberInternalClient, false);
            generatedPort = new MyPort(itf, portName, "server", this.numberInternalClient, true);
            this.internalPorts.add(generatedPort);
            super.add((MutableTreeNode)((Object)generatedPort));
        } else if (type.equals("server")) {
            ++this.numberInternalServer;
            initialPort = new MyPort(itf, portName, type, this.numberInternalServer, false);
            generatedPort = new MyPort(itf, portName, "client", this.numberInternalServer, true);
            this.internalPorts.add(generatedPort);
            super.add((MutableTreeNode)((Object)generatedPort));
        } else if (type.equals("controler")) {
            ++this.numberInternalController;
            initialPort = new MyPort(itf, portName, type, this.numberInternalController, false);
        }
        this.internalPorts.add(initialPort);
        super.add((MutableTreeNode)((Object)initialPort));
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    public ArrayList getVerteces() {
        return this.verteces;
    }

    public Point getOrigin() {
        return this.origin;
    }

    public void setOrigin(Point p) {
        this.origin.x = p.x;
        this.origin.y = p.y;
    }
}

