/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.swing.graph;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphSelectionModel;
import org.jgraph.graph.PortView;
import org.jgraph.graph.VertexView;
import org.objectweb.util.explorer.swing.graph.CCMVertex;
import org.objectweb.util.explorer.swing.graph.CCMVertexView;
import org.objectweb.util.explorer.swing.graph.CacheBounds;
import org.objectweb.util.explorer.swing.graph.CompositeVertex;
import org.objectweb.util.explorer.swing.graph.CompositeVertexView;
import org.objectweb.util.explorer.swing.graph.LayoutAlgorithm;
import org.objectweb.util.explorer.swing.graph.MyGraphSelectionModel;
import org.objectweb.util.explorer.swing.graph.MyPort;
import org.objectweb.util.explorer.swing.graph.MyPortView;
import org.objectweb.util.explorer.swing.graph.PortGraphicsInterface;
import org.objectweb.util.explorer.swing.graph.PrimitiveVertex;
import org.objectweb.util.explorer.swing.graph.PrimitiveVertexView;
import org.objectweb.util.explorer.swing.graph.VertexGraphicsInterface;

public class Graph
extends JGraph {
    private ConnectionSet cs = new ConnectionSet();
    private GraphModel model = new DefaultGraphModel();
    private static PortGraphicsInterface pg;
    private static VertexGraphicsInterface vg;
    private Map attributes;
    private CompositeVertex superComponent = null;
    private ArrayList primitiveVerteces;
    private ArrayList primitiveEdges;
    private Vector vertecesPosition = new Vector();
    protected PrimitiveVertex mainViewedComponent = null;

    public Graph(GraphModel model) {
        super(model);
        this.setSelectionModel((GraphSelectionModel)new MyGraphSelectionModel(this));
        this.attributes = new Hashtable();
        this.model = model;
        this.primitiveVerteces = new ArrayList();
        this.primitiveEdges = new ArrayList();
    }

    public Graph(GraphModel model, PortGraphicsInterface portGraphics, VertexGraphicsInterface vertexGraphics) {
        super(model);
        this.setSelectionModel((GraphSelectionModel)new MyGraphSelectionModel(this));
        this.model = model;
        this.attributes = new Hashtable();
        this.cs = new ConnectionSet();
        this.setPortGraphics(portGraphics);
        this.setVertexGraphics(vertexGraphics);
        this.primitiveVerteces = new ArrayList();
        this.primitiveEdges = new ArrayList();
    }

    public void insertIntoModel(boolean isPrimitif) {
        Object[] cells;
        if (!isPrimitif) {
            ArrayList edges = this.superComponent.getBinding();
            ArrayList verteces = this.superComponent.getVerteces();
            cells = new Object[verteces.size() + edges.size()];
            int j = 0;
            for (j = 0; j < verteces.size(); ++j) {
                cells[j] = verteces.get(j);
            }
            for (int k = j; k < j + edges.size(); ++k) {
                cells[k] = edges.get(k - j);
            }
        } else {
            ArrayList edges = this.primitiveEdges;
            ArrayList verteces = this.primitiveVerteces;
            cells = new Object[verteces.size() + edges.size()];
            int j = 0;
            for (j = 0; j < verteces.size(); ++j) {
                cells[j] = verteces.get(j);
            }
            for (int k = j; k < j + edges.size(); ++k) {
                cells[k] = edges.get(k - j);
            }
        }
        this.model.insert(cells, this.attributes, this.cs, null, null);
    }

    private void updateEmptyVertecesPosition(MyPort sourcePort, MyPort targetPort, boolean isCompositeEdge) {
        TreeNode source = sourcePort.getParent();
        TreeNode target = targetPort.getParent();
        if (isCompositeEdge) {
            if (source instanceof CompositeVertex && ((CompositeVertex)((Object)source)).isOpen()) {
                if (!(target instanceof CompositeVertex) || !((CompositeVertex)((Object)target)).isOpen()) {
                    this.vertecesPosition.add(0, new Vector());
                    Vector newLine = (Vector)this.vertecesPosition.get(0);
                    newLine.setSize(1);
                    newLine.add(0, target);
                }
            } else if (target instanceof CompositeVertex && ((CompositeVertex)((Object)target)).isOpen() && (!(source instanceof CompositeVertex) || !((CompositeVertex)((Object)source)).isOpen())) {
                this.vertecesPosition.add(0, new Vector());
                Vector newLine = (Vector)this.vertecesPosition.get(0);
                newLine.setSize(1);
                newLine.add(0, source);
            }
        } else if (!sourcePort.getType().equals("controler")) {
            this.vertecesPosition.add(0, new Vector());
            Vector newLine = (Vector)this.vertecesPosition.get(0);
            newLine.setSize(2);
            newLine.add(0, source);
            newLine.add(1, target);
        } else {
            this.vertecesPosition.add(0, new Vector());
            Vector newLine1 = (Vector)this.vertecesPosition.get(0);
            newLine1.setSize(1);
            this.vertecesPosition.add(1, new Vector());
            Vector newLine2 = (Vector)this.vertecesPosition.get(1);
            newLine2.setSize(2);
            newLine1.add(0, source);
            newLine2.add(1, target);
        }
    }

    private void updateVertecesPositionWithCompositeEdge(MyPort sourcePort, MyPort targetPort) {
        TreeNode source = sourcePort.getParent();
        TreeNode target = targetPort.getParent();
        if (source instanceof CompositeVertex && ((CompositeVertex)((Object)source)).isOpen()) {
            if (!(target instanceof CompositeVertex) || !((CompositeVertex)((Object)target)).isOpen()) {
                int index = sourcePort.getNumber();
                if (!this.haveTarget(target)) {
                    if (this.vertecesPosition.size() > index) {
                        Vector targetLine = (Vector)this.vertecesPosition.get(index);
                        if (targetLine.get(0) == null) {
                            targetLine.setElementAt(target, 0);
                        } else {
                            targetLine.add(0, target);
                        }
                    } else {
                        int oldSize = this.vertecesPosition.size();
                        int newSize = index + 1;
                        this.vertecesPosition.setSize(index + 1);
                        for (int i = oldSize; i < this.vertecesPosition.size(); ++i) {
                            Vector newLine = new Vector();
                            newLine.setSize(1);
                            this.vertecesPosition.setElementAt(newLine, i);
                        }
                        ((Vector)this.vertecesPosition.get(index)).setElementAt(target, 0);
                    }
                }
            }
        } else if (target instanceof CompositeVertex && ((CompositeVertex)((Object)target)).isOpen() && (!(target instanceof CompositeVertex) || !((CompositeVertex)((Object)target)).isOpen())) {
            int index = targetPort.getNumber();
            if (this.vertecesPosition.size() > index) {
                Vector sourceLine = (Vector)this.vertecesPosition.get(index);
                if (sourceLine.get(sourceLine.size()) == null) {
                    sourceLine.setElementAt(source, sourceLine.size());
                } else {
                    int oldSize = sourceLine.size();
                    sourceLine.setSize(oldSize + 1);
                    sourceLine.add(oldSize, source);
                }
            } else {
                int oldSize = this.vertecesPosition.size();
                this.vertecesPosition.setSize(index + 1);
                for (int i = 0; i < this.vertecesPosition.size(); ++i) {
                    Vector newLine = new Vector();
                    newLine.setSize(1);
                    this.vertecesPosition.add(i, newLine);
                }
                Vector sourceLine = (Vector)this.vertecesPosition.get(index);
                sourceLine.setSize(this.getNbColumn() + 1);
                sourceLine.add(this.getNbColumn(), source);
            }
        }
    }

    private int getNbColumn() {
        int nb = 0;
        for (int i = 0; i < this.vertecesPosition.size(); ++i) {
            Vector line = (Vector)this.vertecesPosition.get(i);
            int lineSize = 0;
            for (int j = 0; j < line.size(); ++j) {
                if (line.get(j) == null) continue;
                ++lineSize;
            }
            if (lineSize <= nb) continue;
            nb = lineSize;
        }
        return nb;
    }

    private boolean haveSource(Object source) {
        int haveSource = 0;
        for (int i = 0; i < this.vertecesPosition.size(); ++i) {
            if (!((Vector)this.vertecesPosition.get(i)).contains(source)) continue;
            ++haveSource;
        }
        return haveSource != 0;
    }

    private boolean haveTarget(Object target) {
        int haveTarget = 0;
        for (int i = 0; i < this.vertecesPosition.size(); ++i) {
            if (!((Vector)this.vertecesPosition.get(i)).contains(target)) continue;
            ++haveTarget;
        }
        return haveTarget != 0;
    }

    private void addTargetAfter(Vector vertecesPosition, int sourceIndexLine, int sourceIndex, Object target) {
        int add = 0;
        for (int i = sourceIndexLine; i < vertecesPosition.size(); ++i) {
            Vector line = (Vector)vertecesPosition.get(i);
            if (line.size() < sourceIndex + 2) {
                line.setSize(sourceIndex + 2);
                line.add(sourceIndex + 1, target);
                ++add;
                continue;
            }
            if (line.get(sourceIndex + 1) != null) continue;
            line.setElementAt(target, sourceIndex + 1);
            ++add;
        }
        if (add == 0) {
            vertecesPosition.setSize(vertecesPosition.size() + 1);
            vertecesPosition.setElementAt(new Vector(), vertecesPosition.size() - 1);
            Vector targetLine = (Vector)vertecesPosition.get(vertecesPosition.size() - 1);
            targetLine.setSize(sourceIndex + 2);
            targetLine.setElementAt(target, sourceIndex + 1);
        }
    }

    private void addSourceBefore(Vector vertecesPosition, int targetIndexLine, int targetIndex, Object source) {
        int add = 0;
        for (int i = targetIndexLine; i < vertecesPosition.size(); ++i) {
            Vector line = (Vector)vertecesPosition.get(i);
            if (line.size() < targetIndex) {
                line.setSize(targetIndex);
                line.add(line.size() - 1, source);
                ++add;
                continue;
            }
            if (line.get(targetIndex - 1) != null) continue;
            ((Vector)vertecesPosition.get(i)).setElementAt(source, targetIndex - 1);
            ++add;
        }
        if (add == 0) {
            vertecesPosition.setSize(vertecesPosition.size() + 1);
            vertecesPosition.setElementAt(new Vector(), vertecesPosition.size() - 1);
            Vector sourceLine = (Vector)vertecesPosition.get(vertecesPosition.size() - 1);
            sourceLine.setSize(targetIndex);
            sourceLine.add(targetIndex - 1, source);
        }
    }

    private int getIndexLineOf(Vector vertecesPosition, Object vertex) {
        int index = 0;
        for (int i = 0; i < vertecesPosition.size(); ++i) {
            if (!((Vector)vertecesPosition.get(i)).contains(vertex)) continue;
            index = i;
        }
        return index;
    }

    public void updateVertecesPosition(Object edge, MyPort sourcePort, MyPort targetPort, boolean isCompositeEdge) {
        if (sourcePort != null && targetPort != null) {
            TreeNode source = sourcePort.getParent();
            TreeNode target = targetPort.getParent();
            if (this.vertecesPosition.isEmpty()) {
                this.updateEmptyVertecesPosition(sourcePort, targetPort, isCompositeEdge);
            } else if (isCompositeEdge) {
                this.updateVertecesPositionWithCompositeEdge(sourcePort, targetPort);
            } else if (!sourcePort.getType().equals("controler")) {
                if (!this.haveSource(source) && !this.haveTarget(target)) {
                    int newIndexLine = this.vertecesPosition.size();
                    this.vertecesPosition.add(newIndexLine, new Vector());
                    Vector newLine = (Vector)this.vertecesPosition.get(newIndexLine);
                    newLine.setSize(2);
                    newLine.add(0, source);
                    newLine.add(1, target);
                } else if (!this.haveSource(source)) {
                    int targetIndexLine = this.getIndexLineOf(this.vertecesPosition, target);
                    Vector targetLine = (Vector)this.vertecesPosition.get(targetIndexLine);
                    int targetIndex = targetLine.indexOf(target);
                    if (targetIndex == 0) {
                        targetLine.add(0, source);
                    } else if (targetLine.get(targetIndex - 1) == null) {
                        targetLine.setElementAt(source, targetIndex - 1);
                    } else {
                        this.addSourceBefore(this.vertecesPosition, targetIndexLine, targetIndex, source);
                    }
                } else if (!this.haveTarget(target)) {
                    int sourceIndexLine = this.getIndexLineOf(this.vertecesPosition, source);
                    Vector sourceLine = (Vector)this.vertecesPosition.get(sourceIndexLine);
                    int sourceIndex = sourceLine.indexOf(source);
                    if (sourceIndex == sourceLine.size()) {
                        sourceLine.setSize(sourceIndex + 2);
                        sourceLine.add(sourceLine.size() - 1, target);
                    } else if (sourceLine.size() > sourceIndex + 1 && sourceLine.get(sourceIndex + 1) == null) {
                        sourceLine.add(sourceIndex + 1, target);
                    } else {
                        this.addTargetAfter(this.vertecesPosition, sourceIndexLine, sourceIndex, target);
                    }
                }
            } else if (!this.haveTarget(source) && !this.haveTarget(target)) {
                int newIndexLine1 = this.vertecesPosition.size();
                this.vertecesPosition.add(newIndexLine1, new Vector());
                Vector newLine1 = (Vector)this.vertecesPosition.get(newIndexLine1);
                int newIndexLine2 = this.vertecesPosition.size();
                this.vertecesPosition.add(newIndexLine2, new Vector());
                Vector newLine2 = (Vector)this.vertecesPosition.get(newIndexLine2);
                newLine1.setSize(1);
                newLine2.setSize(2);
                newLine1.add(0, source);
                newLine2.add(1, target);
            } else if (!this.haveTarget(source)) {
                int targetIndexLine = this.getIndexLineOf(this.vertecesPosition, target);
                Vector targetLine = (Vector)this.vertecesPosition.get(targetIndexLine);
                int targetIndex = targetLine.indexOf(target);
                if (targetIndexLine == 0) {
                    if (targetIndex > 0) {
                        Vector<TreeNode> sourceLine = new Vector<TreeNode>();
                        sourceLine.setSize(targetIndex);
                        sourceLine.setElementAt(source, targetIndex - 1);
                        this.vertecesPosition.add(0, sourceLine);
                    } else {
                        Vector<TreeNode> sourceLine = new Vector<TreeNode>();
                        sourceLine.setSize(1);
                        sourceLine.setElementAt(source, 0);
                        ((Vector)this.vertecesPosition.get(targetIndexLine)).add(0, null);
                        this.vertecesPosition.add(0, sourceLine);
                    }
                } else {
                    Vector sourceLine = (Vector)this.vertecesPosition.get(targetIndexLine - 1);
                    if (sourceLine.size() < targetIndex) {
                        sourceLine.setSize(targetIndex);
                        sourceLine.setElementAt(source, targetIndex - 1);
                    } else if (sourceLine.get(targetIndex - 1) == null) {
                        sourceLine.setElementAt(source, targetIndex - 1);
                    } else {
                        sourceLine.add(targetIndex - 1, source);
                    }
                }
            } else if (!this.haveTarget(target)) {
                int sourceIndexLine = this.getIndexLineOf(this.vertecesPosition, source);
                Vector sourceLine = (Vector)this.vertecesPosition.get(sourceIndexLine);
                int sourceIndex = sourceLine.indexOf(source);
                this.addTargetAfter(this.vertecesPosition, sourceIndexLine, sourceIndex, target);
            }
        }
    }

    public void applyLayout(CompositeVertex component) {
        LayoutAlgorithm algo = new LayoutAlgorithm(this.getVertecesPosition(), vg);
        if (component.getOrigin().x == 0 && component.getOrigin().y == 0) {
            component.setOrigin(VertexGraphicsInterface.SUPER_COMPOSITE_ORIGIN);
        }
        algo.applyLayout(this, component.getOrigin(), component.getSize(), component);
    }

    public void applyLayout(Dimension frameSize) {
        if (this.getVertecesPosition().size() != 0) {
            LayoutAlgorithm algo = new LayoutAlgorithm(this.getVertecesPosition(), vg);
            algo.applyLayout(this, VertexGraphicsInterface.PRIMITIVE_ORIGIN, frameSize, null);
        }
    }

    public void addSuperComponent(CompositeVertex component) {
        if (this.mainViewedComponent == null) {
            this.mainViewedComponent = component;
        }
        AttributeMap componentAttributes = this.getModel().createAttributes();
        Rectangle bounds = CacheBounds.getBounds(this.mainViewedComponent, component);
        if (bounds != null) {
            componentAttributes.put((Object)"bounds", (Object)bounds);
        }
        this.attributes.put(component, componentAttributes);
        this.superComponent = component;
    }

    public void addPrimitiveComponent(PrimitiveVertex component) {
        if (this.mainViewedComponent == null) {
            this.mainViewedComponent = component;
        }
        AttributeMap vertexAttributes = this.model.createAttributes();
        Rectangle bounds = CacheBounds.getBounds(this.mainViewedComponent, component);
        if (bounds != null) {
            vertexAttributes.put((Object)"bounds", (Object)bounds);
            component.setSize(bounds.getSize());
        } else {
            Rectangle2D c1Bounds = vertexAttributes.createRect(10.0, 10.0, (double)Graph.vg.getDefaultSize().width, (double)Graph.vg.getDefaultSize().height);
            GraphConstants.setBounds((Map)vertexAttributes, (Rectangle2D)c1Bounds);
        }
        this.attributes.put(component, vertexAttributes);
        this.primitiveVerteces.add(component);
    }

    public void addPrimitiveEdge() {
        DefaultEdge edge = new DefaultEdge();
        AttributeMap edgeAttrib = this.model.createAttributes();
        this.attributes.put(edge, edgeAttrib);
        int style = 11;
        GraphConstants.setLineStyle((Map)edgeAttrib, (int)style);
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public Vector getVertecesPosition() {
        return this.vertecesPosition;
    }

    public GraphModel getModel() {
        return this.model;
    }

    public static PortGraphicsInterface getPortGraphics() {
        return pg;
    }

    public static VertexGraphicsInterface getVertexGraphics() {
        return vg;
    }

    public void compositeConnect(MyPort sourcePort, MyPort targetPort, boolean isCompositeEdge, CompositeVertex component) {
        Edge edge = component.addBinding(this.model);
        this.cs.connect((Object)edge, (Object)sourcePort, (Object)targetPort);
        this.updateVertecesPosition(edge, sourcePort, targetPort, isCompositeEdge);
    }

    public void primitiveConnect(MyPort sourcePort, MyPort targetPort, boolean isCompositeEdge) {
        DefaultEdge edge = new DefaultEdge();
        this.primitiveEdges.add(edge);
        AttributeMap eAttributes = this.model.createAttributes();
        this.attributes.put(edge, eAttributes);
        int style = 11;
        GraphConstants.setLineStyle((Map)eAttributes, (int)style);
        GraphConstants.setDisconnectable((Map)eAttributes, (boolean)false);
        this.cs.connect((Object)edge, (Object)sourcePort, (Object)targetPort);
        this.updateVertecesPosition(edge, sourcePort, targetPort, isCompositeEdge);
    }

    public ConnectionSet getConnectionSet() {
        return this.cs;
    }

    public void setPortGraphics(PortGraphicsInterface portGraphics) {
        pg = portGraphics;
    }

    public void setVertexGraphics(VertexGraphicsInterface vertexGraphics) {
        vg = vertexGraphics;
    }

    protected PortView createPortView(JGraph g, CellMapper cm, Object cell) {
        return new MyPortView(g, cm, (Object)((MyPort)((Object)cell)));
    }

    private boolean isPrimitiveVertex(Object cell) {
        return cell instanceof PrimitiveVertex;
    }

    private boolean isCompositeVertex(Object cell) {
        return cell instanceof CompositeVertex;
    }

    private boolean isCCMVertex(Object cell) {
        return cell instanceof CCMVertex;
    }

    protected VertexView createVertexView(JGraph g, CellMapper cm, Object cell) {
        if (this.isCompositeVertex(cell)) {
            return new CompositeVertexView(g, cm, (Object)((CompositeVertex)((Object)cell)));
        }
        if (this.isCCMVertex(cell)) {
            return new CCMVertexView(g, cm, (Object)((CCMVertex)((Object)cell)));
        }
        if (this.isPrimitiveVertex(cell)) {
            return new PrimitiveVertexView(g, cm, (Object)((PrimitiveVertex)((Object)cell)));
        }
        return null;
    }

    public CellView createView(JGraph graph, CellMapper mapper, Object cell) {
        Object view = null;
        view = graph.getModel().isPort(cell) ? this.createPortView(graph, mapper, cell) : (graph.getModel().isEdge(cell) ? this.createEdgeView(graph, mapper, cell) : this.createVertexView(graph, mapper, cell));
        mapper.putMapping(cell, (CellView)view);
        view.refresh(true);
        view.update();
        return view;
    }

    public void saveFractalGraph() {
        int i;
        if (this.superComponent != null) {
            CacheBounds.putBounds(this.mainViewedComponent, this.superComponent);
        }
        for (i = 0; i < this.vertecesPosition.size(); ++i) {
            Vector courantLine = (Vector)this.vertecesPosition.get(i);
            for (int j = 0; j < courantLine.size(); ++j) {
                PrimitiveVertex currentVertex = (PrimitiveVertex)((Object)courantLine.get(j));
                if (currentVertex == null) continue;
                CacheBounds.putBounds(this.mainViewedComponent, currentVertex);
            }
        }
        for (i = 0; i < this.primitiveVerteces.size(); ++i) {
            PrimitiveVertex currentVertex = (PrimitiveVertex)((Object)this.primitiveVerteces.get(i));
            if (currentVertex == null) continue;
            CacheBounds.putBounds(this.mainViewedComponent, currentVertex);
        }
    }

    public void saveCCMGraph() {
        for (int i = 0; i < this.primitiveVerteces.size(); ++i) {
            CCMVertex currentVertex = (CCMVertex)((Object)this.primitiveVerteces.get(i));
            if (currentVertex == null || currentVertex.getComponent() == null) continue;
            CacheBounds.putBounds(this.mainViewedComponent, currentVertex);
        }
    }
}

