/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.swing.graph;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;

public class MyEdgeHandle
extends EdgeView.EdgeHandle {
    public MyEdgeHandle(EdgeView edge, GraphContext ctx) {
        super(edge, ctx);
    }

    public void mousePressed(MouseEvent event) {
        System.out.println("mouse event");
        boolean bendable = this.graph.isBendable() && GraphConstants.isBendable((Map)this.edge.getAllAttributes());
        boolean disconnectable = this.graph.isDisconnectable() && GraphConstants.isDisconnectable((Map)this.orig.getAllAttributes());
        int x = event.getX();
        int y = event.getY();
        int index = 0;
        for (index = 0; index < this.r.length; ++index) {
            if (!this.r[index].contains(x, y)) continue;
            this.currentPoint = this.edge.getPoint(index);
            this.source = index == 0 && (this.edge.getSource() == null || disconnectable && GraphConstants.isDisconnectable((Map)this.edge.getSource().getParentView().getAllAttributes()));
            this.target = index == this.r.length - 1 && (this.edge.getTarget() == null || disconnectable && GraphConstants.isDisconnectable((Map)this.edge.getTarget().getParentView().getAllAttributes()));
            break;
        }
        if (!this.isEditing() && this.graph.isMoveable() && GraphConstants.isMoveable((Map)this.edge.getAllAttributes()) && this.loc != null && this.loc.contains(x, y) && !this.isAddPointEvent(event) && !this.isRemovePointEvent(event)) {
            if (event.getClickCount() == this.graph.getEditClickCount()) {
                this.graph.startEditingAtCell((Object)this.edge);
            } else {
                this.label = true;
            }
        }
        if (this.isRemovePointEvent(event) && this.currentPoint != null && !this.source && !this.target && bendable) {
            this.edge.removePoint(index);
            this.mouseReleased(event);
        } else if (this.isAddPointEvent(event) && !this.isEditing() && bendable) {
            int s = this.graph.getHandleSize();
            Rectangle2D rect = this.graph.fromScreen((Rectangle2D)new Rectangle(x - s, y - s, 2 * s, 2 * s));
            if (this.edge.intersects(this.graph.getGraphics(), rect)) {
                Point2D point = this.graph.fromScreen(this.graph.snap((Point2D)new Point(event.getPoint())));
                double min = Double.MAX_VALUE;
                double dist = 0.0;
                for (int i = 0; i < this.edge.getPointCount() - 1; ++i) {
                    Point2D p1;
                    Point2D p = this.edge.getPoint(i);
                    dist = new Line2D.Double(p, p1 = this.edge.getPoint(i + 1)).ptLineDistSq(point);
                    if (!(dist < min)) continue;
                    min = dist;
                    index = i + 1;
                }
                this.edge.addPoint(index, point);
                this.currentPoint = point;
                this.reloadPoints(this.edge);
                this.paint(this.graph.getGraphics());
            }
        }
        if (this.isEditing()) {
            event.consume();
        }
    }
}

