/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.swing.graph;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.jgraph.graph.DefaultGraphCell;
import org.objectweb.util.explorer.swing.graph.Graph;
import org.objectweb.util.explorer.swing.graph.MyPort;
import org.objectweb.util.explorer.swing.graph.PortGraphicsInterface;
import org.objectweb.util.explorer.swing.graph.VertexGraphicsInterface;

public class PrimitiveVertex
extends DefaultGraphCell {
    private static FontRenderContext frc = new FontRenderContext(null, false, false);
    protected static int twoSpaces = PrimitiveVertex.getWidthString("__", "TimesRoman", 18);
    private Object component;
    protected ArrayList ports;
    protected ArrayList clientPorts;
    protected ArrayList serverPorts;
    protected ArrayList controllerPorts;
    private String name;
    private Graph graph;
    private boolean isStarted;
    private boolean isShared;
    protected int numberServer;
    protected int numberClient;
    protected int numberControler;
    protected int numberInternalServer;
    protected int numberInternalClient;
    transient String type;
    protected Dimension size = new Dimension(0, 0);
    protected Dimension compositeSize = new Dimension();
    private boolean controllersDisplay;
    private boolean isFirstPaint;

    public static Rectangle2D getRectString(String str, String police, int size) {
        Font font = new Font(police, 0, size);
        return font.getStringBounds(str, frc);
    }

    public static int getWidthString(String str, String police, int size) {
        Rectangle2D r = PrimitiveVertex.getRectString(str, police, size);
        return (int)r.getWidth();
    }

    public static int getHeightString(String str, String police, int size) {
        Rectangle2D r = PrimitiveVertex.getRectString(str, police, size);
        return (int)r.getHeight();
    }

    public PrimitiveVertex(Object component, String name, Graph graph, Dimension compositeSize, boolean controllersDisplay, boolean isStarted, boolean isShared) {
        super((Object)name);
        this.name = name;
        this.graph = graph;
        this.controllersDisplay = controllersDisplay;
        this.component = component;
        this.type = "primitif";
        this.isStarted = isStarted;
        this.isShared = isShared;
        this.ports = new ArrayList();
        this.clientPorts = new ArrayList();
        this.serverPorts = new ArrayList();
        this.controllerPorts = new ArrayList();
        this.numberServer = 0;
        this.numberClient = 0;
        this.numberControler = 0;
        this.numberInternalServer = 0;
        this.numberInternalClient = 0;
        this.setCompositeSize(compositeSize);
        this.isFirstPaint = true;
    }

    public void addPort(Object itf, String name, String type) {
        MyPort p = null;
        if (type.equals("client") || type.equals("collection")) {
            ++this.numberClient;
            p = new MyPort(itf, name, type, this.numberClient, false);
        } else if (type.equals("server")) {
            ++this.numberServer;
            p = new MyPort(itf, name, type, this.numberServer, false);
        } else if (type.equals("controler")) {
            ++this.numberControler;
            p = new MyPort(itf, name, type, this.numberControler, false);
        }
        super.add(p);
        this.ports.add(p);
    }

    public boolean isFirstPaint() {
        return this.isFirstPaint;
    }

    public void setFirstPaint(boolean isFirstPaint) {
        this.isFirstPaint = isFirstPaint;
    }

    public boolean isShared() {
        return this.isShared;
    }

    public void setShared(boolean isShared) {
        this.isShared = isShared;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void setStarted(boolean isStarted) {
        this.isStarted = isStarted;
    }

    public Object getComponent() {
        return this.component;
    }

    public boolean getControllerDisplay() {
        return this.controllersDisplay;
    }

    public void setControllerDisplay(boolean controllersDisplay) {
        this.controllersDisplay = controllersDisplay;
    }

    public ArrayList getListPorts() {
        return this.ports;
    }

    public MyPort getPort(String name) {
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!((MyPort)((Object)this.ports.get(i))).getName().equals(name)) continue;
            return (MyPort)((Object)this.ports.get(i));
        }
        return null;
    }

    public MyPort getPort(String name, String type, int number) {
        ArrayList ports = type.equals("client") ? this.getListClientPorts() : (type.equals("server") ? this.getListServerPorts() : this.getListControllerPorts());
        for (int i = 0; i < ports.size(); ++i) {
            if (!((MyPort)((Object)ports.get(i))).getName().equals(name) || ((MyPort)((Object)ports.get(i))).getNumber() != number) continue;
            return (MyPort)((Object)ports.get(i));
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int getWidthName() {
        return PrimitiveVertex.getWidthString(this.getName(), "TimesRoman", 18);
    }

    public int getPortLabelWidth(MyPort port) {
        return PrimitiveVertex.getWidthString(port.getName(), "Dialog", 12);
    }

    public int getMinWidth() {
        int maxSizePort = 0;
        ArrayList Ports = this.getListPorts();
        int nPort = Ports.size();
        for (int i = 0; i < nPort; ++i) {
            MyPort port = (MyPort)((Object)Ports.get(i));
            int size = this.getPortLabelWidth(port);
            if (size <= maxSizePort) continue;
            maxSizePort = size;
        }
        return 2 * maxSizePort + this.getWidthName() + twoSpaces + 8;
    }

    public ArrayList getListServerPorts() {
        if (this.serverPorts.size() == 0) {
            ArrayList ports = this.getListPorts();
            for (int i = 0; i < ports.size(); ++i) {
                if (!((MyPort)((Object)ports.get(i))).getType().equals("server")) continue;
                this.serverPorts.add(ports.get(i));
            }
        }
        return this.serverPorts;
    }

    public ArrayList getListClientPorts() {
        if (this.clientPorts.size() == 0) {
            ArrayList ports = this.getListPorts();
            for (int i = 0; i < ports.size(); ++i) {
                if (!((MyPort)((Object)ports.get(i))).getType().equals("client") && !((MyPort)((Object)ports.get(i))).getType().equals("collection")) continue;
                this.clientPorts.add(ports.get(i));
            }
        }
        return this.clientPorts;
    }

    public ArrayList getListControllerPorts() {
        if (this.controllerPorts.size() == 0) {
            ArrayList ports = this.getListPorts();
            for (int i = 0; i < ports.size(); ++i) {
                if (!((MyPort)((Object)ports.get(i))).getType().equals("controler")) continue;
                this.controllerPorts.add(ports.get(i));
            }
        }
        return this.controllerPorts;
    }

    public Dimension getSize() {
        int minWidth;
        VertexGraphicsInterface vg = Graph.getVertexGraphics();
        PortGraphicsInterface pg = Graph.getPortGraphics();
        int portsServer = this.getListServerPorts().size();
        int portsClients = this.getListClientPorts().size();
        int portsControl = this.getListControllerPorts().size();
        if (this.size.height < portsServer * 14) {
            this.size.height = portsServer * 14 + 25;
        }
        if (this.size.height < portsClients * 14) {
            this.size.height = portsClients * 14 + 25;
        }
        if (this.size.width < portsControl * 30) {
            this.size.width = portsControl * 30;
        }
        if ((minWidth = this.getMinWidth()) > 3000) {
            minWidth = 3000;
        }
        if (this.size.width < minWidth) {
            this.size.width = minWidth;
        }
        if (this.size.height == 0 || this.size.height < vg.getDefaultSize().height) {
            this.size.height = vg.getDefaultSize().height;
        }
        if (this.size.width == 0 || this.size.width < vg.getDefaultSize().width) {
            this.size.width = vg.getDefaultSize().width;
        }
        return this.size;
    }

    public void setSize(Dimension d) {
        this.size.width = d.width;
        this.size.height = d.height;
    }

    public Dimension getCompositeSize() {
        return this.compositeSize;
    }

    public void setCompositeSize(Dimension d) {
        this.compositeSize.width = d.width;
        this.compositeSize.height = d.height;
    }
}

