/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.swing.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.VertexRenderer;
import org.jgraph.graph.VertexView;
import org.objectweb.util.explorer.swing.graph.Graph;
import org.objectweb.util.explorer.swing.graph.MyPort;
import org.objectweb.util.explorer.swing.graph.MySizeHandle;
import org.objectweb.util.explorer.swing.graph.PortGraphicsInterface;
import org.objectweb.util.explorer.swing.graph.PrimitiveVertex;
import org.objectweb.util.explorer.swing.graph.VertexGraphicsInterface;

public class PrimitiveVertexView
extends VertexView {
    protected static MyVertexRenderer renderer = new MyVertexRenderer();

    public PrimitiveVertexView(JGraph graph, CellMapper cm, Object cell) {
        super(cell, graph, cm);
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public CellHandle getHandle(GraphContext context) {
        if (GraphConstants.isSizeable((Map)this.getAllAttributes()) && context.getGraph().isSizeable()) {
            return new MySizeHandle(this, context);
        }
        return null;
    }

    public static class MyVertexRenderer
    extends VertexRenderer {
        private PortGraphicsInterface pg = Graph.getPortGraphics();
        private VertexGraphicsInterface vg = Graph.getVertexGraphics();
        private boolean isFirstPaint = true;

        public void resizeVertex(Dimension size) {
            PrimitiveVertex vertex = (PrimitiveVertex)((Object)this.view.getCell());
            vertex.setSize(size);
            AttributeMap vAttributes = vertex.getAttributes();
            Rectangle r = GraphConstants.getBounds((Map)vAttributes).getBounds();
            r.height = size.height;
            r.width = size.width;
            GraphConstants.setBounds((Map)vAttributes, (Rectangle2D)r);
            this.graph.getGraphLayoutCache().update((CellView)this.view);
        }

        public void paint(Graphics g) {
            Dimension size;
            PrimitiveVertex vertex = (PrimitiveVertex)((Object)this.view.getCell());
            int portsServer = vertex.getListServerPorts().size();
            int portsClients = vertex.getListClientPorts().size();
            int portsControl = vertex.getListControllerPorts().size();
            Dimension defaultSize = this.vg.getDefaultSize();
            Dimension initialSize = null;
            if (this.isFirstPaint) {
                size = initialSize = vertex.getSize();
                this.isFirstPaint = false;
            } else {
                size = new Dimension(this.view.getBounds().getBounds().width, this.view.getBounds().getBounds().height);
            }
            if (initialSize != null) {
                if (size.width < initialSize.width) {
                    size.width = initialSize.width;
                }
                if (size.height < initialSize.height) {
                    size.height = initialSize.height;
                }
            }
            if (size.width < defaultSize.width) {
                size.width = defaultSize.width;
            }
            if (size.height < defaultSize.height) {
                size.height = defaultSize.height;
            }
            AttributeMap vAttributes = vertex.getAttributes();
            Rectangle gBounds = g.getClipBounds();
            gBounds.height = size.height;
            gBounds.width = size.width;
            g.setClip(gBounds.x, gBounds.y, gBounds.width, gBounds.height);
            this.resizeVertex(size);
            this.vg.drawVertex(g, vertex.getType(), size, vertex);
            g.setColor(Color.black);
            if (!vertex.isStarted()) {
                g.setColor(new Color(149, 0, 0));
            }
            int vertexLabelLocation = size.width / 2 - (vertex.getName().length() * 7 + 5) / 2;
            g.setFont(new Font("TimesRoman", 0, 18));
            g.drawString(vertex.getName(), vertexLabelLocation, size.height / 2 + 4);
            g.setFont(new Font("Dialog", 0, 12));
            for (int i = 0; i < vertex.getChildCount(); ++i) {
                Point pos;
                int interval;
                MyPort port = (MyPort)((Object)vertex.getChildAt(i));
                String portType = port.getType();
                int portLabelWidth = vertex.getPortLabelWidth(port);
                if (portType.equals("server")) {
                    interval = (size.height - 25) / portsServer;
                    pos = new Point(4, interval * (port.getNumber() - 1) + 25 + this.pg.getPortSize((String)portType, (boolean)false).height);
                    if (portLabelWidth > vertex.getSize().width / 2) {
                        int newPortLabelSize = (this.getBounds().width / 2 - vertex.getName().length() * 7 / 2) / 6;
                        if (port.getName().length() > newPortLabelSize && newPortLabelSize > 3) {
                            g.drawString(port.getName().substring(0, newPortLabelSize - 3) + "...", pos.x, pos.y);
                            continue;
                        }
                        g.drawString(port.getName(), pos.x, pos.y);
                        continue;
                    }
                    g.drawString(port.getName(), pos.x, pos.y);
                    continue;
                }
                if (portType.equals("client") || portType.equals("collection")) {
                    interval = (size.height - 25) / portsClients;
                    pos = new Point(size.width - portLabelWidth - 2 - 3, interval * (port.getNumber() - 1) + 25 + this.pg.getPortSize((String)portType, (boolean)false).height);
                    if (portLabelWidth > vertex.getSize().width / 2) {
                        int vertexLabelSize = vertex.getName().length() * 7;
                        int newPortLabelSize = (this.getBounds().width / 2 - vertex.getName().length() * 7 / 2) / 6;
                        pos.x = this.getBounds().width - newPortLabelSize * 6;
                        if (port.getName().length() > newPortLabelSize && newPortLabelSize > 3) {
                            g.drawString(port.getName().substring(0, newPortLabelSize - 3) + "...", pos.x, pos.y);
                            continue;
                        }
                        g.drawString(port.getName(), pos.x, pos.y);
                        continue;
                    }
                    g.drawString(port.getName(), pos.x, pos.y);
                    continue;
                }
                interval = portsControl > 0 ? size.width / portsControl : 0;
                pos = new Point(2 + interval * (port.getNumber() - 1), 15);
                g.drawString(port.getName(), pos.x, pos.y);
            }
        }
    }
}

