/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.swing.gui.lib;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.objectweb.util.explorer.swing.gui.api.Console;

public class DefaultDialogConsole
extends JDialog
implements Console {
    protected JTextArea textArea_ = null;
    protected Calendar calendar_ = null;

    public DefaultDialogConsole(String title, boolean isModal) {
        this.setModal(isModal);
        this.setTitle(title);
        this.getContentPane().add(this.createBox());
        this.setDefaultCloseOperation(1);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2);
    }

    public void addButtons(Box buttonBox) {
        buttonBox.add(new JButton(new ClearAction()));
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(new JButton(new HideAction()));
    }

    protected Box createBox() {
        Box mainBox = Box.createVerticalBox();
        mainBox.add(Box.createVerticalGlue());
        this.textArea_ = new JTextArea(25, 40);
        this.textArea_.setBorder(BorderFactory.createLineBorder(Color.black));
        this.textArea_.setEditable(false);
        this.textArea_.setLineWrap(true);
        mainBox.add(new JScrollPane(this.textArea_));
        mainBox.add(Box.createVerticalStrut(10));
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(Box.createHorizontalGlue());
        this.addButtons(buttonBox);
        buttonBox.add(Box.createHorizontalGlue());
        mainBox.add(buttonBox);
        mainBox.add(Box.createVerticalStrut(10));
        mainBox.add(Box.createVerticalGlue());
        return mainBox;
    }

    protected String getNumber(int num) {
        return num > 9 ? "" + num : "0" + num;
    }

    protected String getCurrentDate() {
        this.calendar_ = new GregorianCalendar();
        StringBuffer theDate = new StringBuffer();
        theDate.append(this.calendar_.get(1));
        theDate.append("/");
        theDate.append(this.getNumber(this.calendar_.get(2) + 1));
        theDate.append("/");
        theDate.append(this.getNumber(this.calendar_.get(5)));
        theDate.append(" - ");
        theDate.append(this.calendar_.get(9) == 0 ? "AM" : "PM");
        theDate.append(" ");
        theDate.append(this.getNumber(this.calendar_.get(10)));
        theDate.append(":");
        theDate.append(this.getNumber(this.calendar_.get(12)));
        theDate.append(":");
        theDate.append(this.getNumber(this.calendar_.get(13)));
        return theDate.toString();
    }

    public void add(String message) {
        this.textArea_.append("[" + this.getCurrentDate() + "] ");
        this.textArea_.append(message);
    }

    public void clear() {
        this.textArea_.setText("");
    }

    public void show() {
        super.show();
    }

    public void hide() {
        super.hide();
    }

    protected class HideAction
    extends AbstractAction {
        public HideAction() {
            super("Close");
        }

        public void actionPerformed(ActionEvent e) {
            DefaultDialogConsole.this.hide();
        }
    }

    protected class ClearAction
    extends AbstractAction {
        public ClearAction() {
            super("Clear");
        }

        public void actionPerformed(ActionEvent e) {
            DefaultDialogConsole.this.clear();
        }
    }
}

