/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.swing.gui.lib;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.objectweb.util.explorer.swing.gui.api.ValidateReport;
import org.objectweb.util.explorer.swing.gui.lib.AbstractElementBox;
import org.objectweb.util.explorer.swing.gui.lib.DefaultValidateReport;

public class FileChooserBox
extends AbstractElementBox {
    protected JFileChooser fileChooser_;
    protected File file_;
    protected String label_;
    protected JTextField urlField_;

    public FileChooserBox(String label, JFileChooser fileChooser) {
        this(label, fileChooser, true, true);
    }

    public FileChooserBox(String label, JFileChooser fileChooser, boolean isMandatory) {
        this(label, fileChooser, isMandatory, true);
    }

    public FileChooserBox(String label, JFileChooser fileChooser, boolean isMandatory, boolean isEditable) {
        super(isMandatory);
        this.fileChooser_ = fileChooser;
        this.label_ = label;
        this.add(Box.createHorizontalGlue());
        JLabel explorerLabel = new JLabel(label + ": ", 4);
        explorerLabel.setAlignmentX(1.0f);
        explorerLabel.setAlignmentY(0.5f);
        this.add(explorerLabel);
        this.add(Box.createHorizontalStrut(5));
        this.urlField_ = new JTextField();
        this.urlField_.setEditable(isEditable);
        this.urlField_.setPreferredSize(new Dimension(200, 20));
        this.urlField_.setMaximumSize(new Dimension(200, 20));
        this.add(this.urlField_);
        this.add(Box.createHorizontalStrut(5));
        JButton browseButton = new JButton(new BrowseAction(this));
        browseButton.setPreferredSize(new Dimension(20, 20));
        browseButton.setMaximumSize(new Dimension(20, 20));
        this.add(browseButton);
    }

    public ValidateReport validateBox() {
        if (this.isMandatory_ && (this.urlField_.getText() == null || this.urlField_.getText().equals(""))) {
            return new DefaultValidateReport(false, "The \"" + this.label_ + "\" value is mandatory");
        }
        return new DefaultValidateReport();
    }

    public Box getBox() {
        return this;
    }

    public File getFile() {
        return this.file_;
    }

    public URL getURL() {
        try {
            return new URL(this.urlField_.getText());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    protected class BrowseAction
    extends AbstractAction {
        protected Component parent_;

        protected BrowseAction(Component parent) {
            super("...", null);
            this.parent_ = parent;
        }

        public void actionPerformed(ActionEvent ae) {
            int returnVal = FileChooserBox.this.fileChooser_.showOpenDialog(this.parent_);
            if (returnVal == 0) {
                FileChooserBox.this.file_ = FileChooserBox.this.fileChooser_.getSelectedFile();
                try {
                    FileChooserBox.this.urlField_.setText(FileChooserBox.this.fileChooser_.getSelectedFile().toURL().toString());
                }
                catch (MalformedURLException e) {
                    System.out.println(this.getClass().getName() + " Malformed URL Exception !");
                }
            }
        }
    }
}

