/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.swing.gui.lib;

import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JScrollPane;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.util.explorer.api.Entry;
import org.objectweb.util.explorer.api.Tree;
import org.objectweb.util.explorer.swing.api.Explorer;
import org.objectweb.util.explorer.swing.gui.api.ValidateReport;
import org.objectweb.util.explorer.swing.gui.lib.AbstractElementBox;
import org.objectweb.util.explorer.swing.gui.lib.DefaultValidateReport;

public class TreeBox
extends AbstractElementBox {
    protected Component component_;
    protected Tree treeItf_;
    protected Explorer explorerItf_;
    protected JScrollPane scrollPane_;

    public TreeBox(Component treeComponent) {
        this(treeComponent, true);
    }

    public TreeBox(Component treeComponent, boolean isMandatory) {
        super(isMandatory);
        this.initAttributes(treeComponent);
        this.scrollPane_ = new JScrollPane(this.explorerItf_.getTree());
        this.add(this.scrollPane_);
    }

    public void preInitialize() {
        if (this.explorerItf_ != null) {
            this.explorerItf_.setPopupEnabled(false);
            this.explorerItf_.setDragAndDropEnabled(false);
        }
    }

    public void postInitialize() {
        if (this.explorerItf_ != null) {
            this.explorerItf_.setPopupEnabled(true);
            this.explorerItf_.setDragAndDropEnabled(true);
        }
    }

    protected void initAttributes(Component treeComponent) {
        this.component_ = treeComponent;
        if (this.component_ != null) {
            try {
                this.treeItf_ = (Tree)this.component_.getFcInterface("tree");
                this.explorerItf_ = (Explorer)this.component_.getFcInterface("explorer");
            }
            catch (NoSuchInterfaceException e) {
                e.printStackTrace();
            }
        }
    }

    public ValidateReport validateBox() {
        if (this.isMandatory_ && this.getObject() == null) {
            return new DefaultValidateReport(false, "You must select a component");
        }
        return new DefaultValidateReport();
    }

    public Box getBox() {
        return this;
    }

    public Object getObject() {
        Object o = null;
        Entry entry = this.treeItf_.getSelectedEntry();
        if (entry != null) {
            o = entry.getValue();
        }
        return o;
    }

    public void setPreferredSize(Dimension d) {
        this.scrollPane_.setPreferredSize(d);
    }
}

