/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.swing.gui.lib;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.util.explorer.api.Entry;
import org.objectweb.util.explorer.api.Tree;
import org.objectweb.util.explorer.swing.api.Explorer;
import org.objectweb.util.explorer.swing.gui.api.TreeChooserObserver;
import org.objectweb.util.explorer.swing.gui.api.ValidateReport;
import org.objectweb.util.explorer.swing.gui.lib.AbstractElementBox;
import org.objectweb.util.explorer.swing.gui.lib.DefaultValidateReport;

public class TreeChooserBox
extends AbstractElementBox {
    protected String label_;
    protected JButton browseButton_;
    protected org.objectweb.fractal.api.Component component_;
    protected Tree treeItf_;
    protected Explorer explorerItf_;
    protected JTextField textField_;
    protected Object object_;
    protected TreeChooserObserver treeChooserObserver_ = null;

    public TreeChooserBox(String label, org.objectweb.fractal.api.Component treeComponent) {
        this(label, treeComponent, true);
    }

    public TreeChooserBox(String label, org.objectweb.fractal.api.Component treeComponent, boolean isMandatory) {
        super(isMandatory);
        this.label_ = label;
        this.initAttributes(treeComponent);
        if (this.explorerItf_ != null) {
            this.explorerItf_.setPopupEnabled(false);
            this.explorerItf_.setDragAndDropEnabled(false);
        }
        this.add(Box.createHorizontalGlue());
        JLabel explorerLabel = new JLabel(label + ": ", 4);
        explorerLabel.setAlignmentX(1.0f);
        explorerLabel.setAlignmentY(0.5f);
        this.add(explorerLabel);
        this.add(Box.createHorizontalStrut(5));
        this.textField_ = new JTextField();
        this.textField_.setEditable(false);
        this.textField_.setPreferredSize(new Dimension(200, 20));
        this.textField_.setMaximumSize(new Dimension(200, 20));
        this.add(this.textField_);
        this.add(Box.createHorizontalStrut(5));
        this.browseButton_ = new JButton(new BrowseAction(this));
        this.browseButton_.setPreferredSize(new Dimension(20, 20));
        this.browseButton_.setMaximumSize(new Dimension(20, 20));
        this.add(this.browseButton_);
    }

    protected void initAttributes(org.objectweb.fractal.api.Component treeComponent) {
        this.component_ = treeComponent;
        if (this.component_ != null) {
            try {
                this.treeItf_ = (Tree)this.component_.getFcInterface("tree");
                this.explorerItf_ = (Explorer)this.component_.getFcInterface("explorer");
            }
            catch (NoSuchInterfaceException e) {
                e.printStackTrace();
            }
        }
    }

    public ValidateReport validateBox() {
        if (this.isMandatory_ && this.getObject() == null) {
            return new DefaultValidateReport(false, "The \"" + this.label_ + "\" value is mandatory");
        }
        return new DefaultValidateReport();
    }

    public void preInitialize() {
        if (this.explorerItf_ != null) {
            this.explorerItf_.setPopupEnabled(false);
            this.explorerItf_.setDragAndDropEnabled(false);
        }
    }

    public void postInitialize() {
        if (this.explorerItf_ != null) {
            this.explorerItf_.setPopupEnabled(true);
            this.explorerItf_.setDragAndDropEnabled(true);
        }
    }

    public Object getObject() {
        return this.object_;
    }

    public void setTreeChooserObserver(TreeChooserObserver treeChooserObserver) {
        this.treeChooserObserver_ = treeChooserObserver;
    }

    protected class BrowseAction
    extends AbstractAction {
        protected Component parent_;

        protected BrowseAction(Component parent) {
            super("...", null);
            this.parent_ = parent;
        }

        public void actionPerformed(ActionEvent ae) {
            Object o;
            Entry entry;
            if (TreeChooserBox.this.treeChooserObserver_ != null) {
                TreeChooserBox.this.initAttributes(TreeChooserBox.this.treeChooserObserver_.refresh());
                TreeChooserBox.this.explorerItf_.setPopupEnabled(false);
            }
            JPanel treePanel = new JPanel();
            treePanel.setLayout(new GridLayout(1, 0));
            treePanel.setPreferredSize(new Dimension(450, 350));
            treePanel.add(new JScrollPane(TreeChooserBox.this.explorerItf_.getTree()));
            int result = JOptionPane.showOptionDialog((Component)ae.getSource(), treePanel, "Select an object", 2, -1, null, null, null);
            if (result == 0 && (entry = TreeChooserBox.this.treeItf_.getSelectedEntry()) != null && (o = entry.getValue()) != null) {
                TreeChooserBox.this.object_ = o;
                TreeChooserBox.this.textField_.setText(entry.getName().toString());
            }
        }
    }
}

