/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.swing.lib;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.util.explorer.api.Panel;
import org.objectweb.util.explorer.api.Tree;
import org.objectweb.util.explorer.api.TreeView;
import org.objectweb.util.explorer.core.common.api.Description;
import org.objectweb.util.explorer.core.common.api.Synchronization;
import org.objectweb.util.explorer.core.common.lib.BindingFeature;
import org.objectweb.util.explorer.interpreter.api.DescriptionInterpreter;
import org.objectweb.util.explorer.resolver.api.PropertyResolver;
import org.objectweb.util.explorer.swing.api.ViewPanel;
import org.objectweb.util.explorer.swing.panel.WhitePanel;

public class DefaultViewPanel
extends BindingFeature
implements Synchronization,
ViewPanel {
    protected JPanel viewPanel_ = null;
    protected Panel userPanel_ = null;
    protected Panel whitePanel_ = new WhitePanel();
    protected TreeView currentTreeView_ = null;

    public DefaultViewPanel() {
        this.viewPanel_ = new JPanel();
        this.viewPanel_.setLayout(new GridLayout(1, 0));
        this.viewPanel_.setPreferredSize(new Dimension(400, 500));
        this.viewPanel_.add((JPanel)this.whitePanel_.getPanel());
    }

    protected PropertyResolver getPropertyResolver() {
        try {
            return (PropertyResolver)this.lookupFc("property-resolver");
        }
        catch (NoSuchInterfaceException e) {
            this.getTrace().warn("property-resolver: interface not found!");
            return null;
        }
    }

    protected DescriptionInterpreter getDescriptionInterpreter() {
        try {
            return (DescriptionInterpreter)this.lookupFc("description-interpreter");
        }
        catch (NoSuchInterfaceException e) {
            this.getTrace().warn("description-interpreter: interface not found!");
            return null;
        }
    }

    protected Tree getTree() {
        try {
            return (Tree)this.lookupFc("tree");
        }
        catch (NoSuchInterfaceException e) {
            this.getTrace().warn("tree: interface not found!");
            return null;
        }
    }

    protected void setViewPanel(Panel newPanel) {
        this.viewPanel_.removeAll();
        this.userPanel_ = newPanel;
        this.viewPanel_.add(new JScrollPane((JPanel)this.userPanel_.getPanel()));
        this.viewPanel_.revalidate();
    }

    public String[] clientFc() {
        return new String[]{"tree", "property-resolver", "description-interpreter"};
    }

    public void refresh(TreeView treeView) {
        if (this.userPanel_ != null && this.currentTreeView_ != null) {
            this.userPanel_.unselected(this.currentTreeView_);
        }
        if (treeView != null) {
            Description desc = this.getPropertyResolver().resolve("panel", treeView.getSelectedEntry());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("property-resolver", this.getPropertyResolver());
            map.put("description-interpreter", this.getDescriptionInterpreter());
            map.put("tree", this.getTree());
            Panel p = (Panel)this.getDescriptionInterpreter().interprete(desc, map);
            if (p != null) {
                this.currentTreeView_ = treeView;
                p.selected(treeView);
                this.setViewPanel(p);
            } else {
                this.userPanel_ = null;
                this.setViewPanel(this.whitePanel_);
            }
        }
    }

    public JPanel getViewPanel() {
        return this.viewPanel_;
    }
}

