/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.swing.menu;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.objectweb.util.explorer.api.MenuItem;
import org.objectweb.util.explorer.api.MenuItemTreeView;
import org.objectweb.util.explorer.core.menu.api.AcceleratorDescription;
import org.objectweb.util.explorer.core.menu.api.ItemDescription;
import org.objectweb.util.explorer.core.menu.api.MenuItemTreeViewConfiguration;
import org.objectweb.util.explorer.core.menu.api.MnemonicDescription;
import org.objectweb.util.explorer.swing.icon.EmptyIconProvider;
import org.objectweb.util.trace.TraceSystem;

public class GenericAction
extends AbstractAction {
    protected MenuItem delegate_;
    protected MenuItemTreeView treeView_;
    protected boolean isUserIcon_ = true;

    public GenericAction(ItemDescription itemDesc, MenuItem action, MenuItemTreeView treeView, Icon icon, boolean enabled) {
        super(itemDesc.getLabel(), icon);
        KeyStroke key;
        this.delegate_ = action;
        this.treeView_ = treeView;
        if (icon == null) {
            this.putValue("SmallIcon", new EmptyIconProvider().newIcon(null));
            this.isUserIcon_ = false;
        }
        this.putValue("ShortDescription", itemDesc.getLabel());
        MnemonicDescription md = itemDesc.getMnemonicDescription();
        if (md != null && !md.isEmpty()) {
            this.putValue("MnemonicKey", new Integer(Character.toUpperCase(md.getMnemonicCharacter())));
        }
        if ((key = this.getKeyStroke(itemDesc.getAcceleratorDescription())) != null) {
            this.putValue("AcceleratorKey", key);
        }
        this.setEnabled(enabled);
    }

    protected KeyStroke getKeyStroke(AcceleratorDescription acceleratorDesc) {
        if (acceleratorDesc != null && !acceleratorDesc.isEmpty()) {
            int modifier = 0;
            modifier = (acceleratorDesc.getAltKey() ? 8 : 0) | (acceleratorDesc.getCtrlKey() ? 2 : 0) | (acceleratorDesc.getShiftKey() ? 1 : 0) | (acceleratorDesc.getMetaKey() ? 4 : 0);
            if (modifier == 0) {
                return KeyStroke.getKeyStroke(Character.toUpperCase(acceleratorDesc.getAcceleratorCharacter()));
            }
            return KeyStroke.getKeyStroke((int)Character.toUpperCase(acceleratorDesc.getAcceleratorCharacter()), modifier);
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            ((MenuItemTreeViewConfiguration)((Object)this.treeView_)).setEvent(actionEvent);
            this.delegate_.actionPerformed(this.treeView_);
        }
        catch (Throwable e) {
            TraceSystem.get((String)"explorer").warn(this.getClass().getName() + " exception: " + e.getMessage());
            e.printStackTrace(System.err);
            JOptionPane.showMessageDialog(null, e.getClass().getName() + ":\n" + e.getMessage(), "Exception (" + actionEvent.getActionCommand() + ")", 0);
        }
        this.treeView_.getTree().refreshAll();
    }

    public boolean isUserIcon() {
        return this.isUserIcon_;
    }
}

