/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.rmi;

import java.util.HashMap;
import org.objectweb.fractal.adl.Launcher;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.rmi.registry.Registry;

public class ClientLauncher {
    public static void main(String[] args) throws Exception {
        System.setSecurityManager(new SecurityManager());
        String definition = args[0];
        System.out.println("ClientLauncher " + definition);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("fractaladl.factory", "org.objectweb.fractal.adl.BasicFactory");
        context.put("fractaladl.backend", "org.objectweb.fractal.adl.FractalBackend");
        context.put("fractaladl.itf", "r");
        for (int i = 1; i < args.length; ++i) {
            String[] mapping = args[i].split("=");
            try {
                Component server = Registry.lookup(mapping[1]);
                if (server == null) {
                    System.err.println("Warning: Virtual-node '" + mapping[0] + "' is mapped to the local JVM as node '" + mapping[1] + "' was not found!");
                    continue;
                }
                System.out.println("Info: Virtual-node '" + mapping[0] + "' is mapped to node '" + mapping[1] + "'.");
                context.put(mapping[0], (String)server);
                continue;
            }
            catch (Exception exc) {
                System.err.println("Warning: Virtual-node '" + mapping[0] + "' is mapped to the local JVM as Registry.lookup(" + mapping[1] + ") failed due to " + exc);
            }
        }
        Launcher launcher = new Launcher(context);
        launcher.compile(definition);
    }
}

