/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.rmi;

import java.net.URI;
import org.objectweb.fractal.rmi.registry.NamingService;
import org.objectweb.fractal.rmi.registry.Registry;
import org.objectweb.fractal.util.Fractal;

public class ServerLauncher {
    public static void main(String[] args) throws Exception {
        System.setSecurityManager(new SecurityManager());
        String serverName = null;
        String registryHostPortAddress = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-h") || arg.equals("--help")) {
                ServerLauncher.usage(0);
                continue;
            }
            if (arg.equals("-r") || arg.equals("--registry")) {
                if (registryHostPortAddress != null) {
                    System.err.println("Error: The Fractal RMI Registry address is already set!");
                    ServerLauncher.usage(-1);
                }
                registryHostPortAddress = args[++i];
                continue;
            }
            if (!arg.startsWith("-")) {
                if (serverName != null) {
                    System.err.println("Error: The server name is already set!");
                    ServerLauncher.usage(-1);
                }
                serverName = arg;
                continue;
            }
            System.err.println("Error: Invalid argument " + arg);
            ServerLauncher.usage(-1);
        }
        if (serverName == null) {
            System.err.println("Error: The server name is not set!");
            ServerLauncher.usage(-1);
        }
        URI registryUri = Registry.newURI(registryHostPortAddress);
        NamingService ns = Registry.getRegistry(registryUri);
        ns.rebind(serverName, Fractal.getBootstrapComponent());
        System.out.println("Server ready and available at " + registryUri + "/" + serverName);
    }

    public static void usage(int exitStatus) {
        System.out.println("usage: java ServerLauncher [-h|--help] [-r|--registry host[:port]] <server_name>");
        System.out.println("  -h|--help     Displays usage.");
        System.out.println("  -r|--registry Sets the address of the Fractal RMI Registry to register the server.");
        System.out.println("                By default, the local one is used.");
        System.out.println("  <server_name> Sets the server name used to register the server.");
        System.exit(exitStatus);
    }
}

