/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jonathan.libs.resources;

import org.objectweb.jonathan.apis.kernel.Context;
import org.objectweb.jonathan.apis.kernel.ContextFactory;
import org.objectweb.jonathan.apis.kernel.InternalException;
import org.objectweb.jonathan.apis.resources.Job;
import org.objectweb.jonathan.apis.resources.Scheduler;
import org.objectweb.jonathan.libs.resources.LoggerProvider;
import org.objectweb.util.monolog.api.BasicLevel;

public class JScheduler
implements Scheduler {
    static int sched_nb = 0;
    String sched_name;
    int id = 0;
    int max_waiting;
    public boolean verbose;
    JJob[] pool;
    int waiting;
    protected ContextFactory context_factory;
    private static ThreadLocal threadLocalContext = new ThreadLocal();

    public JScheduler(ContextFactory context_factory) {
        this(5, false, context_factory);
    }

    public JScheduler(int max_waiting, boolean verbose, ContextFactory context_factory) {
        this.max_waiting = max_waiting;
        this.verbose = verbose;
        this.context_factory = context_factory;
        this.sched_name = "p" + sched_nb++ + ".";
        this.pool = new JJob[max_waiting];
        this.waiting = 0;
    }

    public synchronized Job newJob() {
        JJob job = null;
        job = this.waiting == 0 ? new JJob(this.sched_name + this.id++) : this.pool[--this.waiting];
        return job;
    }

    public Job getCurrent() {
        if (Thread.currentThread() instanceof Job) {
            return (Job)((Object)Thread.currentThread());
        }
        return new KJob();
    }

    public void yield() {
        Thread.yield();
    }

    public void wait(Object lock) throws InterruptedException {
        lock.wait();
    }

    public void wait(Object lock, long millis) throws InterruptedException {
        lock.wait(millis);
    }

    public void notify(Object lock) {
        lock.notify();
    }

    public void notifyAll(Object lock) {
        lock.notifyAll();
    }

    public void escape() {
    }

    public void enter() {
    }

    boolean register(JJob job) {
        if (this.waiting < this.pool.length) {
            this.pool[this.waiting++] = job;
            return true;
        }
        return false;
    }

    class KJob
    implements Job {
        public void run(Runnable m) {
            if (LoggerProvider.logger != null && LoggerProvider.logger.isLoggable(BasicLevel.WARN)) {
                LoggerProvider.logger.log(BasicLevel.WARN, (Object)"KJob being asked to run a new task... Alert!");
            }
        }

        public Context getContext() {
            if (threadLocalContext.get() == null) {
                threadLocalContext.set(JScheduler.this.context_factory.newContext());
            }
            return (Context)threadLocalContext.get();
        }
    }

    class JJob
    extends Thread
    implements Job {
        Runnable task;
        Context context;

        JJob(String name) {
            super(name);
            this.setDaemon(true);
            this.task = null;
            this.context = null;
            super.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void run() {
            try {
                Object object = this;
                synchronized (object) {
                    while (this.task == null) {
                        this.wait();
                    }
                }
                while (true) {
                    this.task.run();
                    if (this.context != null) {
                        this.context.release();
                        this.context = null;
                    }
                    object = JScheduler.this;
                    synchronized (object) {
                        if (!JScheduler.this.register(this)) {
                            return;
                        }
                        this.task = null;
                        if (this.task != null) continue;
                    }
                    object = this;
                    synchronized (object) {
                        while (this.task == null) {
                            this.wait();
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public synchronized void run(Runnable message) {
            if (this.task != null) {
                throw new InternalException("Can't use this job more than once");
            }
            this.task = message;
            this.notify();
        }

        public Context getContext() {
            if (this.context == null) {
                this.context = JScheduler.this.context_factory.newContext();
            }
            return this.context;
        }

        public String toString() {
            return this.getName();
        }
    }
}

