/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jonathan.libs.resources.tcpip;

import java.io.IOException;
import org.objectweb.jonathan.apis.kernel.JonathanException;
import org.objectweb.jonathan.apis.protocols.ip.IpConnection;
import org.objectweb.jonathan.apis.protocols.ip.IpSession;
import org.objectweb.jonathan.apis.protocols.ip.TcpIpConnectionMgr;
import org.objectweb.jonathan.apis.protocols.ip.TcpIpSrvConnectionFactory;
import org.objectweb.jonathan.apis.resources.Chunk;

public class JConnectionMgr
implements TcpIpConnectionMgr {
    Connection[] connections = new Connection[101];
    int connects = 0;
    SrvConnectionFactory server_connection_factories;
    Connection first_idle;
    Connection last_idle;
    int idle;
    protected TcpIpConnectionMgr factory;
    public int max_idle;

    public JConnectionMgr(int max_idle, TcpIpConnectionMgr connection_factory) {
        this.max_idle = max_idle;
        this.factory = connection_factory;
    }

    public String getCanonicalHostName(String hostname) {
        return this.factory.getCanonicalHostName(hostname);
    }

    public synchronized IpConnection newCltConnection(String host, int port, IpSession session) throws JonathanException {
        host = this.getCanonicalHostName(host);
        int hash = host.hashCode() + port;
        int len = this.connections.length;
        int index = (hash & Integer.MAX_VALUE) % len;
        Connection connection = this.connections[index];
        while (connection != null) {
            if (connection.getPort() == port && connection.getHostName().equals(host)) {
                if (connection.getSession() == null) {
                    connection.acquire();
                    connection.setSession(session);
                    return connection;
                }
                if (connection.getSession().equals(session)) {
                    connection.acquire();
                    return connection;
                }
            }
            connection = connection.next;
        }
        connection = this.newCltConnection(this.factory.newCltConnection(host, port, session));
        Connection first = this.connections[index];
        this.connections[index] = connection;
        connection.next = first;
        ++this.connects;
        if (this.connects > len / 2) {
            this.rehash(len);
        }
        return connection;
    }

    public TcpIpSrvConnectionFactory newSrvConnectionFactory(int port) throws JonathanException {
        SrvConnectionFactory fac = this.server_connection_factories;
        while (fac != null && fac.getPort() != port) {
            fac = fac.next;
        }
        if (fac == null) {
            fac = this.server_connection_factories;
            this.server_connection_factories = new SrvConnectionFactory(this.factory.newSrvConnectionFactory(port));
            this.server_connection_factories.next = fac;
            return this.server_connection_factories;
        }
        return fac;
    }

    protected Connection newCltConnection(IpConnection connection) throws JonathanException {
        return new Connection(connection);
    }

    void remove(Connection connection) {
        int hash = connection.hashCode();
        int len = this.connections.length;
        int index = (hash & Integer.MAX_VALUE) % len;
        Connection current = this.connections[index];
        Object prev = null;
        while (current != null) {
            if (connection == current) {
                if (prev == null) {
                    this.connections[index] = current.next;
                } else {
                    prev.next = current.next;
                }
                return;
            }
            current = current.next;
        }
    }

    void add(Connection connection) {
        int hash = connection.hashCode();
        int len = this.connections.length;
        int index = (hash & Integer.MAX_VALUE) % len;
        Connection first = this.connections[index];
        this.connections[index] = connection;
        connection.next = first;
        ++this.connects;
        if (this.connects > len / 2) {
            this.rehash(len);
        }
    }

    void removeConnectionFactory(SrvConnectionFactory factory) {
        SrvConnectionFactory connection_factory = this.server_connection_factories;
        SrvConnectionFactory prev = null;
        while (connection_factory != null) {
            if (connection_factory == factory) {
                if (prev != null) {
                    prev.next = connection_factory.next;
                } else {
                    this.server_connection_factories = connection_factory.next;
                }
                return;
            }
            prev = connection_factory;
            connection_factory = connection_factory.next;
        }
    }

    void rehash(int len) {
        int new_len = 2 * len + 1;
        Connection[] new_table = new Connection[new_len];
        for (int i = 0; i < len; ++i) {
            Connection entry = this.connections[i];
            while (entry != null) {
                Connection next_entry = entry.next;
                int index = (entry.hashCode() & Integer.MAX_VALUE) % new_len;
                Connection first_entry = new_table[index];
                new_table[index] = entry;
                entry.next = first_entry;
                entry = next_entry;
            }
        }
        this.connections = new_table;
    }

    class SrvConnectionFactory
    implements TcpIpSrvConnectionFactory {
        TcpIpSrvConnectionFactory delegate;
        SrvConnectionFactory next;

        SrvConnectionFactory(TcpIpSrvConnectionFactory delegate) throws JonathanException {
            this.delegate = delegate;
        }

        public IpConnection newSrvConnection(IpSession session) throws JonathanException {
            return this.delegate.newSrvConnection(session);
        }

        public int getPort() {
            return this.delegate.getPort();
        }

        public String getHostName() {
            return this.delegate.getHostName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            JConnectionMgr jConnectionMgr = JConnectionMgr.this;
            synchronized (jConnectionMgr) {
                this.delegate.close();
                JConnectionMgr.this.removeConnectionFactory(this);
            }
        }
    }

    public class Connection
    implements IpConnection {
        Connection next_idle;
        Connection prev_idle;
        int acquired;
        Connection next;
        IpConnection delegate;

        protected Connection(IpConnection delegate) {
            this.delegate = delegate;
            this.acquired = 1;
        }

        public int available() throws IOException {
            return this.delegate.available();
        }

        public void receive(Chunk chunk, int to_read) throws IOException {
            this.delegate.receive(chunk, to_read);
        }

        public void emit(Chunk chunk) throws IOException {
            this.delegate.emit(chunk);
        }

        public int getPort() {
            return this.delegate.getPort();
        }

        public String getHostName() {
            return this.delegate.getHostName();
        }

        public IpSession getSession() {
            return this.delegate.getSession();
        }

        public void setSession(IpSession session) {
            this.delegate.setSession(session);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete() {
            JConnectionMgr jConnectionMgr = JConnectionMgr.this;
            synchronized (jConnectionMgr) {
                this.delegate.delete();
                this.withdraw();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() {
            JConnectionMgr jConnectionMgr = JConnectionMgr.this;
            synchronized (jConnectionMgr) {
                ++this.acquired;
                if (this.acquired == 1) {
                    if (this.prev_idle != null) {
                        this.prev_idle.next_idle = this.next_idle;
                    } else {
                        JConnectionMgr.this.first_idle = this.next_idle;
                    }
                    if (this.next_idle != null) {
                        this.next_idle.prev_idle = this.prev_idle;
                    } else {
                        JConnectionMgr.this.last_idle = this.prev_idle;
                    }
                    this.next_idle = null;
                    this.prev_idle = null;
                    --JConnectionMgr.this.idle;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            JConnectionMgr jConnectionMgr = JConnectionMgr.this;
            synchronized (jConnectionMgr) {
                --this.acquired;
                if (this.acquired == 0) {
                    if (JConnectionMgr.this.last_idle != null) {
                        JConnectionMgr.this.last_idle.next_idle = this;
                        JConnectionMgr.this.last_idle = this;
                    } else {
                        JConnectionMgr.this.last_idle = JConnectionMgr.this.first_idle = this;
                    }
                    if (JConnectionMgr.this.idle >= JConnectionMgr.this.max_idle) {
                        JConnectionMgr.this.first_idle.delegate.release();
                        JConnectionMgr.this.first_idle.withdraw();
                    }
                    ++JConnectionMgr.this.idle;
                }
            }
        }

        void withdraw() {
            JConnectionMgr.this.remove(this);
            if (this.next_idle != null) {
                if (this.prev_idle != null) {
                    this.prev_idle.next_idle = this.next_idle;
                    this.next_idle.prev_idle = this.prev_idle;
                } else {
                    JConnectionMgr.this.first_idle = this.next_idle;
                    this.next_idle.prev_idle = null;
                }
                --JConnectionMgr.this.idle;
            } else if (this.prev_idle != null) {
                JConnectionMgr.this.last_idle = this.prev_idle;
                this.prev_idle.next_idle = null;
                --JConnectionMgr.this.idle;
            } else if (JConnectionMgr.this.last_idle == this) {
                JConnectionMgr.this.last_idle = null;
                this.prev_idle = null;
                --JConnectionMgr.this.idle;
            }
        }

        public String toString() {
            return "JConnectionMgr.Connection" + System.identityHashCode(this) + "[" + this.delegate + "]";
        }

        public int hashCode() {
            int hashcode = this.delegate.getPort() + this.delegate.getHostName().hashCode();
            return hashcode;
        }
    }
}

