/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.deployment.scheduling.core.lib;

import java.util.LinkedList;
import java.util.List;
import org.objectweb.deployment.scheduling.core.api.Scheduler;
import org.objectweb.deployment.scheduling.core.api.Task;
import org.objectweb.deployment.scheduling.core.lib.AbstractTask;

public class BasicScheduler
implements Scheduler {
    protected Task[] prepareScheduling(Task[] tasks, boolean traceTimer) {
        LinkedList<Task> readyTasks = new LinkedList<Task>();
        long tb = System.currentTimeMillis();
        for (int i = 0; i < tasks.length; ++i) {
            Task currentTask = tasks[i];
            if (currentTask.getNumberOfPreviousTasks() != 0) continue;
            readyTasks.addLast(currentTask);
        }
        long te = System.currentTimeMillis();
        if (traceTimer) {
            System.err.println("Compute previous, next, ready tasks = " + (te - tb) + " milliseconds");
            System.err.println(readyTasks.size() + " tasks with no previous tasks.");
        }
        tb = System.currentTimeMillis();
        int index = 0;
        while (readyTasks.size() != 0) {
            Task currentTask;
            tasks[index] = currentTask = (Task)readyTasks.removeFirst();
            ++index;
            List nextTaskList = ((AbstractTask)currentTask).nextTasks_;
            ((AbstractTask)currentTask).nextTasks_ = null;
            if (nextTaskList == null) continue;
            int m = nextTaskList.size();
            for (int i = 0; i < m; ++i) {
                Task nextTask = (Task)nextTaskList.get(i);
                if (!nextTask.decrementNumberOfPreviousTasks()) continue;
                readyTasks.addLast(nextTask);
            }
        }
        te = System.currentTimeMillis();
        if (traceTimer) {
            System.err.println("Schedule tasks = " + (te - tb) + " milliseconds");
            System.err.println(index + " tasks to execute.");
        }
        return tasks;
    }

    protected void doSchedule(Task[] tasks, Object context, boolean traceTimer) {
        for (int i = 0; i < tasks.length; ++i) {
            Task currentTask = tasks[i];
            try {
                currentTask.execute(context);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            if (i % 10000 != 0) continue;
        }
    }

    public void schedule(Task[] tasks, Object context) {
        boolean traceTimer = false;
        if (traceTimer) {
            System.err.println(tasks.length + " tasks to schedule...");
        }
        long tb = System.currentTimeMillis();
        Task[] ta = this.prepareScheduling(tasks, traceTimer);
        long te = System.currentTimeMillis();
        if (traceTimer) {
            System.err.println("Prepare Scheduling time = " + (te - tb) + " milliseconds");
        }
        tb = System.currentTimeMillis();
        this.doSchedule(ta, context, traceTimer);
        te = System.currentTimeMillis();
        if (traceTimer) {
            System.err.println("Do Scheduling time = " + (te - tb) + " milliseconds");
        }
    }
}

