/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.fractal.adl.Node;

public abstract class AbstractNode
implements Node {
    private String source;
    private Map decorations = null;
    public static int mode = 0;
    static int[] newNodes = new int[6];
    static int freeNodes = 0;
    static int newDecorations = 0;
    static int freeDecorations = 0;
    static int maxDecorations = 0;

    public AbstractNode() {
        int n = mode;
        newNodes[n] = newNodes[n] + 1;
    }

    public String astGetSource() {
        return this.source;
    }

    public void astSetSource(String src) {
        this.source = src;
    }

    public Object astGetDecoration(String name) {
        return this.decorations == null ? null : this.decorations.get(name);
    }

    public Object astSetDecoration(String name, Object decoration) {
        this.initDecorations();
        Object result = this.decorations.put(name, decoration);
        if (this.decorations.size() > maxDecorations) {
            maxDecorations = this.decorations.size();
        }
        return result;
    }

    public Map getDecorations() {
        return this.decorations;
    }

    public void astSetDecorations(AbstractNode an) {
        if (an.decorations == null) {
            return;
        }
        this.initDecorations();
        this.decorations.putAll(an.decorations);
        if (this.decorations.size() > maxDecorations) {
            maxDecorations = this.decorations.size();
        }
    }

    private void initDecorations() {
        if (this.decorations == null) {
            ++newDecorations;
            this.decorations = new HashMap(4);
        }
    }

    public void astSetAttributes(Node node) {
        this.astSetAttributes(node.astGetAttributes());
    }

    public String astGetAttribute(String name) {
        return (String)this.astGetAttributes().get(name);
    }

    public static void printStats() {
    }
}

