/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl;

import java.util.Map;
import org.objectweb.deployment.scheduling.component.api.FactoryProviderTask;
import org.objectweb.deployment.scheduling.component.api.InstanceProviderTask;
import org.objectweb.deployment.scheduling.core.api.Scheduler;
import org.objectweb.deployment.scheduling.core.api.Task;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractNode;
import org.objectweb.fractal.adl.AdvancedTaskMap;
import org.objectweb.fractal.adl.BasicTaskMap;
import org.objectweb.fractal.adl.Compiler;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Factory;
import org.objectweb.fractal.adl.Loader;
import org.objectweb.fractal.adl.attributes.FractalAttributeBuilder;
import org.objectweb.fractal.adl.bindings.FractalBindingBuilder;
import org.objectweb.fractal.adl.components.FractalComponentBuilder;
import org.objectweb.fractal.adl.implementations.FractalImplementationBuilder;
import org.objectweb.fractal.adl.types.FractalTypeBuilder;
import org.objectweb.fractal.api.control.BindingController;

public class BasicFactory
implements BindingController,
Factory {
    public static final String LOADER_BINDING = "loader";
    public static final String COMPILER_BINDING = "compiler";
    public static final String SCHEDULER_BINDING = "scheduler";
    public Loader loader;
    public Compiler compiler;
    public Scheduler scheduler;

    public String[] listFc() {
        return new String[]{LOADER_BINDING, COMPILER_BINDING, SCHEDULER_BINDING};
    }

    public Object lookupFc(String itf) {
        if (itf.equals(LOADER_BINDING)) {
            return this.loader;
        }
        if (itf.equals(COMPILER_BINDING)) {
            return this.compiler;
        }
        if (itf.equals(SCHEDULER_BINDING)) {
            return this.scheduler;
        }
        return null;
    }

    public void bindFc(String itf, Object value) {
        if (itf.equals(LOADER_BINDING)) {
            this.loader = (Loader)value;
        } else if (itf.equals(COMPILER_BINDING)) {
            this.compiler = (Compiler)value;
        } else if (itf.equals(SCHEDULER_BINDING)) {
            this.scheduler = (Scheduler)value;
        }
    }

    public void unbindFc(String itf) {
        if (itf.equals(LOADER_BINDING)) {
            this.loader = null;
        } else if (itf.equals(COMPILER_BINDING)) {
            this.compiler = null;
        } else if (itf.equals(SCHEDULER_BINDING)) {
            this.scheduler = null;
        }
    }

    public Object newComponentType(String name, Map context) throws ADLException {
        Definition d = this.loader.load(name, context);
        BasicTaskMap m = new BasicTaskMap();
        this.compiler.compile(d, m, context);
        try {
            m.getTask("type", d).execute(context);
            return ((FactoryProviderTask)m.getTask("type", d)).getFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object newComponent(String name, Map context) throws ADLException {
        long te;
        Definition d;
        long tb;
        boolean traceTimer = false;
        if (traceTimer) {
            AbstractNode.printStats();
        }
        try {
            tb = System.currentTimeMillis();
            d = this.loader.load(name, context);
            te = System.currentTimeMillis();
            if (traceTimer) {
                System.err.println(name + ": Loading time = " + (te - tb) + " milliseconds");
                long rest = this.loader.printStats(te - tb);
                float p = (float)rest / (float)(te - tb) * 100.0f;
                System.err.println("Rest = " + rest + " (" + p + "%) milliseconds.");
            }
        }
        finally {
            if (context != null && context.get("NO_CLEANUP") == null) {
                tb = System.currentTimeMillis();
                this.loader.cleanUpCaches();
                te = System.currentTimeMillis();
                if (traceTimer) {
                    System.err.println(name + ": Cleaning up time = " + (te - tb) + " milliseconds");
                }
            }
        }
        tb = System.currentTimeMillis();
        AdvancedTaskMap m = new AdvancedTaskMap();
        m.traceTimer = traceTimer;
        this.compiler.compile(d, m, context);
        te = System.currentTimeMillis();
        if (traceTimer) {
            System.err.println(name + ": Compiling time = " + (te - tb) + " milliseconds.");
        }
        Task[] ts = m.getTasks();
        InstanceProviderTask createTask = (InstanceProviderTask)m.getTask("create", d);
        if (traceTimer) {
            System.err.println(name + ": " + ts.length + " tasks.");
        }
        m = null;
        d = null;
        if (traceTimer) {
            AbstractNode.printStats();
            FractalAttributeBuilder.printStats();
            FractalBindingBuilder.printStats();
            FractalComponentBuilder.printStats();
            FractalImplementationBuilder.printStats();
            FractalTypeBuilder.printStats();
        }
        tb = System.currentTimeMillis();
        this.scheduler.schedule(ts, context);
        Object result = createTask.getInstance();
        te = System.currentTimeMillis();
        if (traceTimer) {
            System.err.println(name + ": Execution time = " + (te - tb) + " milliseconds");
            FractalAttributeBuilder.printStats();
            FractalBindingBuilder.printStats();
            FractalComponentBuilder.printStats();
            FractalImplementationBuilder.printStats();
            FractalTypeBuilder.printStats();
        }
        ts = null;
        if (traceTimer) {
            AbstractNode.printStats();
        }
        return result;
    }
}

