/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.fractal.adl.Node;

public abstract class NodeClassLoader
extends ClassLoader
implements Opcodes {
    private Map bytecodes = new HashMap();

    public NodeClassLoader(ClassLoader parent) {
        super(parent);
    }

    public ClassWriter generateClass(String className, String astNodeName, String superClass, String[] itfs) throws ClassNotFoundException {
        String owner = className.replace('.', '/');
        String node = Type.getInternalName(Node.class);
        ClassWriter cw = new ClassWriter(1);
        cw.visit(196653, 1, owner, null, superClass, itfs);
        MethodVisitor icv = cw.visitMethod(1, "<init>", "()V", null, null);
        icv.visitVarInsn(25, 0);
        icv.visitMethodInsn(183, superClass, "<init>", "()V");
        MethodVisitor astGetType = cw.visitMethod(1, "astGetType", "()Ljava/lang/String;", null, null);
        astGetType.visitLdcInsn((Object)astNodeName);
        astGetType.visitInsn(176);
        astGetType.visitMaxs(0, 0);
        MethodVisitor ani = cw.visitMethod(1, "astNewInstance", "()L" + node + ";", null, null);
        ani.visitTypeInsn(187, owner);
        ani.visitInsn(89);
        ani.visitMethodInsn(183, owner, "<init>", "()V");
        ani.visitInsn(176);
        ani.visitMaxs(0, 0);
        MethodVisitor aga = cw.visitMethod(1, "astGetAttributes", "()Ljava/util/Map;", null, null);
        aga.visitTypeInsn(187, "java/util/HashMap");
        aga.visitInsn(89);
        aga.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V");
        aga.visitVarInsn(58, 1);
        MethodVisitor astGetAttribute = cw.visitMethod(1, "astGetAttribute", "(Ljava/lang/String;)Ljava/lang/String;", null, null);
        MethodVisitor asa = cw.visitMethod(1, "astSetAttributes", "(Ljava/util/Map;)V", null, null);
        MethodVisitor astSetAttributes = cw.visitMethod(1, "astSetAttributes", "(L" + node + ";)V", null, null);
        cw.visitField(10, "nodeTypes", "[Ljava/lang/String;", null, null);
        MethodVisitor astGetNodeTypes = cw.visitMethod(1, "astGetNodeTypes", "()[Ljava/lang/String;", null, null);
        astGetNodeTypes.visitFieldInsn(178, owner, "nodeTypes", "[Ljava/lang/String;");
        astGetNodeTypes.visitInsn(176);
        astGetNodeTypes.visitMaxs(0, 0);
        MethodVisitor initNodeTypes = cw.visitMethod(8, "<clinit>", "()V", null, null);
        initNodeTypes.visitIntInsn(17, this.getNodeCount(itfs));
        initNodeTypes.visitTypeInsn(189, "java/lang/String");
        MethodVisitor agns = cw.visitMethod(1, "astGetNodes", "(Ljava/lang/String;)[L" + node + ";", null, null);
        Label agnsEnd = new Label();
        MethodVisitor aan = cw.visitMethod(1, "astAddNode", "(L" + node + ";)V", null, null);
        aan.visitVarInsn(25, 1);
        aan.visitMethodInsn(185, "org/objectweb/fractal/adl/Node", "astGetType", "()Ljava/lang/String;");
        aan.visitVarInsn(58, 2);
        Label aanEnd = new Label();
        MethodVisitor arn = cw.visitMethod(1, "astRemoveNode", "(L" + node + ";)V", null, null);
        arn.visitVarInsn(25, 1);
        arn.visitMethodInsn(185, "org/objectweb/fractal/adl/Node", "astGetType", "()Ljava/lang/String;");
        arn.visitVarInsn(58, 2);
        Label arnEnd = new Label();
        int count = 0;
        HashSet<String> methods = new HashSet<String>();
        for (int i = 0; i < itfs.length; ++i) {
            Method[] meths = this.loadClass(itfs[i].replace('/', '.')).getMethods();
            for (int j = 0; j < meths.length; ++j) {
                Label l;
                String fieldDesc;
                String field;
                Method meth = meths[j];
                String name = meth.getName();
                String desc = Type.getMethodDescriptor((Method)meth);
                if (methods.contains(name + desc)) continue;
                methods.add(name + desc);
                MethodVisitor cv = cw.visitMethod(1, name, desc, null, null);
                if (name.startsWith("get")) {
                    field = NodeClassLoader.getFieldName(name, 3);
                    if (!desc.endsWith(")Ljava/lang/String;")) {
                        boolean single = desc.indexOf(")[") == -1;
                        initNodeTypes.visitInsn(89);
                        initNodeTypes.visitIntInsn(17, count++);
                        initNodeTypes.visitLdcInsn((Object)NodeClassLoader.getASTName(name, single));
                        initNodeTypes.visitInsn(83);
                        if (single) {
                            this.generateGetNodeMethod(agns, owner, name, field, desc.substring(2), agnsEnd);
                        } else {
                            this.generateGetNodesMethod(agns, owner, name, field, agnsEnd);
                        }
                    }
                    if (desc.startsWith("()[")) {
                        fieldDesc = "Ljava/util/List;";
                        String elemDesc = desc.substring(3);
                        cw.visitField(2, field, fieldDesc, null, null);
                        cv.visitVarInsn(25, 0);
                        cv.visitFieldInsn(180, owner, field, fieldDesc);
                        cv.visitInsn(89);
                        Label l2 = new Label();
                        cv.visitJumpInsn(199, l2);
                        cv.visitInsn(87);
                        cv.visitInsn(3);
                        cv.visitTypeInsn(189, elemDesc.substring(1, elemDesc.length() - 1));
                        cv.visitTypeInsn(192, "[" + elemDesc);
                        cv.visitInsn(176);
                        cv.visitLabel(l2);
                        cv.visitInsn(89);
                        cv.visitMethodInsn(185, "java/util/List", "size", "()I");
                        cv.visitTypeInsn(189, elemDesc.substring(1, elemDesc.length() - 1));
                        cv.visitMethodInsn(185, "java/util/List", "toArray", "([Ljava/lang/Object;)[Ljava/lang/Object;");
                        cv.visitTypeInsn(192, "[" + elemDesc);
                        cv.visitInsn(176);
                        cv.visitMaxs(0, 0);
                        icv.visitVarInsn(25, 0);
                        icv.visitInsn(1);
                        icv.visitFieldInsn(181, owner, field, fieldDesc);
                        this.generateAddNodesMethod(aan, owner, name, field, fieldDesc, aanEnd, true);
                        this.generateAddNodesMethod(arn, owner, name, field, fieldDesc, arnEnd, false);
                        continue;
                    }
                    fieldDesc = desc.substring(2);
                    cw.visitField(2, field, fieldDesc, null, null);
                    cv.visitVarInsn(25, 0);
                    cv.visitFieldInsn(180, owner, field, fieldDesc);
                    cv.visitInsn(176);
                    cv.visitMaxs(0, 0);
                    if (fieldDesc.equals("Ljava/lang/String;")) {
                        aga.visitVarInsn(25, 1);
                        aga.visitLdcInsn((Object)NodeClassLoader.getASTName(name, true));
                        aga.visitVarInsn(25, 0);
                        aga.visitFieldInsn(180, owner, field, fieldDesc);
                        aga.visitMethodInsn(182, "java/util/HashMap", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                        aga.visitInsn(87);
                        asa.visitVarInsn(25, 0);
                        asa.visitVarInsn(25, 1);
                        asa.visitLdcInsn((Object)NodeClassLoader.getASTName(name, true));
                        asa.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
                        asa.visitTypeInsn(192, "java/lang/String");
                        asa.visitFieldInsn(181, owner, field, fieldDesc);
                        l = this.generateIf(astGetAttribute, 1, NodeClassLoader.getASTName(name, true));
                        astGetAttribute.visitVarInsn(25, 0);
                        astGetAttribute.visitFieldInsn(180, owner, field, fieldDesc);
                        astGetAttribute.visitInsn(176);
                        astGetAttribute.visitLabel(l);
                        astSetAttributes.visitVarInsn(25, 0);
                        astSetAttributes.visitFieldInsn(180, owner, field, fieldDesc);
                        Label l1 = new Label();
                        astSetAttributes.visitJumpInsn(199, l1);
                        astSetAttributes.visitVarInsn(25, 1);
                        astSetAttributes.visitTypeInsn(193, Type.getInternalName(meth.getDeclaringClass()));
                        Label l2 = new Label();
                        astSetAttributes.visitJumpInsn(153, l2);
                        astSetAttributes.visitVarInsn(25, 1);
                        astSetAttributes.visitTypeInsn(192, Type.getInternalName(meth.getDeclaringClass()));
                        astSetAttributes.visitMethodInsn(185, Type.getInternalName(meth.getDeclaringClass()), name, desc);
                        astSetAttributes.visitInsn(89);
                        astSetAttributes.visitVarInsn(58, 2);
                        Label l3 = new Label();
                        astSetAttributes.visitJumpInsn(198, l3);
                        astSetAttributes.visitVarInsn(25, 0);
                        astSetAttributes.visitVarInsn(25, 2);
                        astSetAttributes.visitFieldInsn(181, owner, field, fieldDesc);
                        astSetAttributes.visitLabel(l3);
                        astSetAttributes.visitLabel(l2);
                        astSetAttributes.visitLabel(l1);
                        continue;
                    }
                    this.generateAddNodeMethod(aan, owner, name, field, fieldDesc, aanEnd, true);
                    this.generateAddNodeMethod(arn, owner, name, field, fieldDesc, arnEnd, false);
                    continue;
                }
                if (name.startsWith("set")) {
                    field = NodeClassLoader.getFieldName(name, 3);
                    fieldDesc = desc.substring(1, desc.length() - 2);
                    cv.visitVarInsn(25, 0);
                    cv.visitVarInsn(25, 1);
                    cv.visitFieldInsn(181, owner, field, fieldDesc);
                    cv.visitInsn(177);
                    cv.visitMaxs(0, 0);
                    continue;
                }
                if (name.startsWith("add")) {
                    field = NodeClassLoader.getFieldName(name, 3) + "s";
                    fieldDesc = "Ljava/util/List;";
                    cv.visitVarInsn(25, 0);
                    cv.visitFieldInsn(180, owner, field, fieldDesc);
                    l = new Label();
                    cv.visitJumpInsn(199, l);
                    cv.visitVarInsn(25, 0);
                    cv.visitTypeInsn(187, "java/util/ArrayList");
                    cv.visitInsn(89);
                    cv.visitInsn(4);
                    cv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "(I)V");
                    cv.visitFieldInsn(181, owner, field, fieldDesc);
                    cv.visitLabel(l);
                    cv.visitVarInsn(25, 0);
                    cv.visitFieldInsn(180, owner, field, fieldDesc);
                    cv.visitVarInsn(25, 1);
                    cv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z");
                    cv.visitInsn(87);
                    cv.visitInsn(177);
                    cv.visitMaxs(0, 0);
                    continue;
                }
                if (name.startsWith("remove")) {
                    field = NodeClassLoader.getFieldName(name, 6) + "s";
                    fieldDesc = "Ljava/util/List;";
                    cv.visitVarInsn(25, 0);
                    cv.visitFieldInsn(180, owner, field, fieldDesc);
                    cv.visitInsn(89);
                    l = new Label();
                    cv.visitJumpInsn(199, l);
                    cv.visitInsn(87);
                    cv.visitInsn(177);
                    cv.visitLabel(l);
                    cv.visitVarInsn(25, 1);
                    cv.visitMethodInsn(185, "java/util/List", "remove", "(Ljava/lang/Object;)Z");
                    cv.visitInsn(87);
                    cv.visitInsn(177);
                    cv.visitMaxs(0, 0);
                    continue;
                }
                if (!name.startsWith("list")) continue;
                field = NodeClassLoader.getFieldName(name, 4);
                fieldDesc = "Ljava/util/List;";
                cv.visitVarInsn(25, 0);
                cv.visitFieldInsn(180, owner, field, fieldDesc);
                cv.visitInsn(176);
                cv.visitMaxs(0, 0);
            }
        }
        icv.visitInsn(177);
        icv.visitMaxs(0, 0);
        aga.visitVarInsn(25, 1);
        aga.visitInsn(176);
        aga.visitMaxs(0, 0);
        astGetAttribute.visitInsn(1);
        astGetAttribute.visitInsn(176);
        astGetAttribute.visitMaxs(0, 0);
        astSetAttributes.visitInsn(177);
        astSetAttributes.visitMaxs(0, 0);
        asa.visitInsn(177);
        asa.visitMaxs(0, 0);
        initNodeTypes.visitFieldInsn(179, owner, "nodeTypes", "[Ljava/lang/String;");
        initNodeTypes.visitInsn(177);
        initNodeTypes.visitMaxs(0, 0);
        agns.visitLabel(agnsEnd);
        agns.visitInsn(1);
        agns.visitInsn(176);
        agns.visitMaxs(0, 0);
        aan.visitLabel(aanEnd);
        aan.visitInsn(177);
        aan.visitMaxs(0, 0);
        arn.visitLabel(arnEnd);
        arn.visitInsn(177);
        arn.visitMaxs(0, 0);
        return cw;
    }

    protected Class defineClass(String name, byte[] b) {
        this.bytecodes.put(name.replace('.', '/') + ".class", b);
        return this.defineClass(name, b, 0, b.length);
    }

    public InputStream getResourceAsStream(String name) {
        byte[] b;
        InputStream is = super.getResourceAsStream(name);
        if (is == null && (b = (byte[])this.bytecodes.get(name)) != null) {
            is = new ByteArrayInputStream(b);
        }
        return is;
    }

    private int getNodeCount(String[] itfs) throws ClassNotFoundException {
        int count = 0;
        HashSet<String> methods = new HashSet<String>();
        for (int i = 0; i < itfs.length; ++i) {
            Method[] meths = this.loadClass(itfs[i].replace('/', '.')).getMethods();
            for (int j = 0; j < meths.length; ++j) {
                Method meth = meths[j];
                String name = meth.getName();
                String desc = Type.getMethodDescriptor((Method)meth);
                if (methods.contains(name + desc)) continue;
                methods.add(name + desc);
                if (!name.startsWith("get") || desc.endsWith(")Ljava/lang/String;")) continue;
                ++count;
            }
        }
        return count;
    }

    private void generateGetNodeMethod(MethodVisitor cv, String owner, String name, String field, String fieldDesc, Label end) {
        Label l = this.generateIf(cv, 1, NodeClassLoader.getASTName(name, true));
        cv.visitInsn(4);
        cv.visitTypeInsn(189, Type.getInternalName(Node.class));
        cv.visitInsn(89);
        cv.visitInsn(3);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, owner, field, fieldDesc);
        cv.visitInsn(83);
        cv.visitInsn(176);
        cv.visitLabel(l);
    }

    private void generateGetNodesMethod(MethodVisitor cv, String owner, String name, String field, Label end) {
        Label l = this.generateIf(cv, 1, NodeClassLoader.getASTName(name, false));
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, owner, field, "Ljava/util/List;");
        cv.visitInsn(89);
        cv.visitInsn(89);
        Label ln = new Label();
        cv.visitJumpInsn(199, ln);
        cv.visitInsn(87);
        cv.visitInsn(3);
        cv.visitTypeInsn(189, Type.getInternalName(Node.class));
        cv.visitTypeInsn(192, "[" + Type.getDescriptor(Node.class));
        cv.visitInsn(176);
        cv.visitLabel(ln);
        cv.visitMethodInsn(185, "java/util/List", "size", "()I");
        cv.visitTypeInsn(189, Type.getInternalName(Node.class));
        cv.visitMethodInsn(185, "java/util/List", "toArray", "([Ljava/lang/Object;)[Ljava/lang/Object;");
        cv.visitTypeInsn(192, "[" + Type.getDescriptor(Node.class));
        cv.visitInsn(176);
        cv.visitLabel(l);
    }

    private void generateAddNodeMethod(MethodVisitor cv, String owner, String name, String field, String fieldDesc, Label end, boolean add) {
        String s = NodeClassLoader.getASTName(name, true);
        Label l = this.generateIf(cv, 2, s);
        cv.visitVarInsn(25, 0);
        if (add) {
            cv.visitVarInsn(25, 1);
            cv.visitTypeInsn(192, fieldDesc.substring(1, fieldDesc.length() - 1));
        } else {
            cv.visitInsn(1);
        }
        cv.visitFieldInsn(181, owner, field, fieldDesc);
        cv.visitInsn(177);
        cv.visitLabel(l);
    }

    private void generateAddNodesMethod(MethodVisitor cv, String owner, String name, String field, String fieldDesc, Label end, boolean add) {
        String s = NodeClassLoader.getASTName(name, false);
        Label l = this.generateIf(cv, 2, s);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, owner, field, fieldDesc);
        Label ln = new Label();
        cv.visitJumpInsn(199, ln);
        cv.visitVarInsn(25, 0);
        cv.visitTypeInsn(187, "java/util/ArrayList");
        cv.visitInsn(89);
        cv.visitInsn(3);
        cv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "(I)V");
        cv.visitFieldInsn(181, owner, field, fieldDesc);
        cv.visitLabel(ln);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, owner, field, fieldDesc);
        cv.visitVarInsn(25, 1);
        cv.visitMethodInsn(185, "java/util/List", add ? "add" : "remove", add ? "(Ljava/lang/Object;)Z" : "(Ljava/lang/Object;)Z");
        cv.visitInsn(87);
        cv.visitInsn(177);
        cv.visitLabel(l);
    }

    private Label generateIf(MethodVisitor cv, int var, String name) {
        Label l = new Label();
        cv.visitVarInsn(25, var);
        cv.visitLdcInsn((Object)name);
        cv.visitMethodInsn(182, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z");
        cv.visitJumpInsn(153, l);
        return l;
    }

    public static String getASTName(String name, boolean single) {
        char c = Character.toLowerCase(name.charAt(3));
        if (single) {
            return c + name.substring(4);
        }
        return c + name.substring(4, name.length() - 1);
    }

    public static String getFieldName(String name, int prefix) {
        char c = Character.toLowerCase(name.charAt(prefix));
        return "_" + c + name.substring(prefix + 1);
    }
}

