/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.apply;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Factory;
import org.objectweb.fractal.adl.FactoryFactory;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.apply.Applier;
import org.objectweb.fractal.adl.apply.Apply;
import org.objectweb.fractal.adl.apply.ApplyContainer;
import org.objectweb.fractal.adl.apply.BasicApplyContext;
import org.objectweb.fractal.adl.arguments.ArgumentComponentLoader;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.ComponentHelper;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.util.Fractal;

public class ApplyArgumentComponentLoader
extends ArgumentComponentLoader {
    protected Factory factory;

    public void resolveComponentContainer(List loaded, ComponentContainer topLevelDefinition, ComponentContainer container, Map context) throws ADLException {
        List comps = container.listComponents();
        if (comps != null) {
            int m = comps.size();
            for (int i = 0; i < m; ++i) {
                Component comp = (Component)comps.get(i);
                this.resolveComponentContainer(loaded, topLevelDefinition, comp, context);
                String definition = comp.getDefinition();
                if (definition != null) {
                    Definition d;
                    comp.setDefinition(null);
                    ((Node)((Object)comp)).astSetDecoration("definition", definition);
                    List defs = this.parseDefinitions(definition);
                    if (defs.size() == 1 && this.isShared((String)defs.get(0))) {
                        Component c;
                        if (definition.startsWith("./")) {
                            definition = definition.substring(2);
                        }
                        if ((c = ComponentHelper.getPathComponent(topLevelDefinition, definition)) == null) {
                            throw new ADLException("No such component (" + definition + ")", (Node)((Object)comp));
                        }
                        if (!c.getName().equals(comp.getName())) {
                            throw new ADLException("Shared components with distinct names not yet supported", (Node)((Object)comp));
                        }
                        ((Node)((Object)c)).astSetDecoration("SHARED", "TRUE");
                        comps.set(i, c);
                        continue;
                    }
                    try {
                        d = this.resolveDefinitions(loaded, defs, context);
                    }
                    catch (ADLException e) {
                        throw new ADLException("Cannot load referenced definition(s)", (Node)((Object)comp), e);
                    }
                    HashMap<Object, Node> replacements = new HashMap<Object, Node>();
                    Node merged = this.merge((Node)((Object)comp), (Node)((Object)d), replacements);
                    Node applied = this.apply(merged, loaded, topLevelDefinition, context);
                    comps.set(i, applied);
                    replacements.put(comp, applied);
                    replacements.put(merged, applied);
                    long tb = System.currentTimeMillis();
                    ComponentHelper.replaceComponents(topLevelDefinition, replacements, new Object());
                    this.incrTimer(0, System.currentTimeMillis() - tb);
                    continue;
                }
                Node applied = this.apply((Node)((Object)comp), loaded, topLevelDefinition, context);
                comps.set(i, applied);
                if (((Node)((Object)comp)).astGetDecoration("SHARED") == null) continue;
                HashMap<Component, Node> replacements = new HashMap<Component, Node>();
                replacements.put(comp, applied);
                long tb = System.currentTimeMillis();
                ComponentHelper.replaceComponents(topLevelDefinition, replacements, new Object());
                this.incrTimer(0, System.currentTimeMillis() - tb);
            }
        }
    }

    protected Node apply(Node node, List loaded, ComponentContainer topLevelDefinition, Map context) throws ADLException {
        if (node instanceof ApplyContainer) {
            Apply[] applies = ((ApplyContainer)((Object)node)).getApplys();
            for (int i = 0; i < applies.length; ++i) {
                Apply apply = applies[i];
                String applyDefinition = apply.getDefinition();
                context.put("NO_TRACE", "YES");
                if (this.factory == null) {
                    this.factory = FactoryFactory.getFactory("org.objectweb.fractal.adl.FractalBackend", context);
                }
                org.objectweb.fractal.api.Component applierComponent = (org.objectweb.fractal.api.Component)this.factory.newComponent(applyDefinition, context);
                context.remove("NO_TRACE");
                try {
                    Fractal.getLifeCycleController((org.objectweb.fractal.api.Component)applierComponent).startFc();
                }
                catch (NoSuchInterfaceException ignored) {
                }
                catch (IllegalLifeCycleException exception) {
                    throw new Error("", exception);
                }
                try {
                    System.err.println("ApplyLoader: execute applier " + applyDefinition + " on " + node);
                    Applier applier = (Applier)applierComponent.getFcInterface("applier");
                    BasicApplyContext applyContext = new BasicApplyContext(topLevelDefinition, null, node, apply, context);
                    applier.apply(applyContext);
                    Node result = applyContext.getResult();
                    if (result != null) {
                        this.resolveComponentContainer(loaded, topLevelDefinition, (ComponentContainer)((Object)result), context);
                        result = this.apply(result, loaded, topLevelDefinition, context);
                        HashMap replacements = new HashMap();
                        node = this.merge(node, result, replacements);
                        long tb = System.currentTimeMillis();
                        ComponentHelper.replaceComponents(topLevelDefinition, replacements, new Object());
                        this.incrTimer(0, System.currentTimeMillis() - tb);
                    }
                }
                catch (ADLException exception) {
                    this.reportError(exception);
                }
                catch (NoSuchInterfaceException exception) {
                    this.reportError(new ADLException(applyDefinition + " has not an 'applier' server interface", (Node)((Object)apply), null));
                }
                catch (ClassCastException exception) {
                    this.reportError(new ADLException(applyDefinition + " does not implement the Applier interface", (Node)((Object)apply), null));
                }
                ((ApplyContainer)((Object)node)).removeApply(apply);
            }
        }
        return node;
    }
}

