/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.apply;

import java.util.List;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.apply.Applier;
import org.objectweb.fractal.adl.apply.Apply;
import org.objectweb.fractal.adl.apply.ApplyContext;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.ComponentHelper;

public class AutoSharing
implements Applier {
    public void apply(ApplyContext context) throws ADLException {
        ComponentContainer currentComponentContainer = (ComponentContainer)((Object)context.getCurrentNode());
        Apply apply = context.getApply();
        ComponentContainer applyComponentContainer = (ComponentContainer)((Object)apply);
        ComponentHelper.normalizeComponentContainer(applyComponentContainer, new Object());
        Component[] components = applyComponentContainer.getComponents();
        for (int c = 0; c < components.length; ++c) {
            Component component = components[c];
            String name = component.getName();
            String definition = component.getDefinition();
            ComponentContainer searchComponentContainer = currentComponentContainer;
            if (definition.startsWith("./")) {
                definition = definition.substring(2);
            } else if (definition.startsWith("//")) {
                definition = definition.substring(2);
                searchComponentContainer = context.getTopLevelDefinition();
            }
            Component sharedComponent = ComponentHelper.getPathComponent(searchComponentContainer, definition);
            if (sharedComponent == null) {
                System.err.println("No such component (" + definition + ") in " + AutoSharing.getName(searchComponentContainer));
                return;
            }
            ((Node)((Object)sharedComponent)).astSetDecoration("SHARED", "TRUE");
            AutoSharing.replaceComponents(currentComponentContainer, name, sharedComponent, new Object());
        }
    }

    protected static String getName(Object node) {
        if (node instanceof Definition) {
            return ((Definition)node).getName();
        }
        if (node instanceof Component) {
            return ((Component)node).getName();
        }
        return null;
    }

    protected static String getDefinition(Object node) {
        if (node instanceof Component) {
            return ((Component)node).getDefinition();
        }
        return null;
    }

    public static void replaceComponents(ComponentContainer container, String name, Component replacement, Object marker) {
        List comps = container.listComponents();
        if (comps != null) {
            if (((Node)((Object)container)).astSetDecoration("MARKER", marker) == marker) {
                return;
            }
            int m = comps.size();
            for (int i = 0; i < m; ++i) {
                Component comp = (Component)comps.get(i);
                if (name.equals(comp.getName())) {
                    comps.set(i, replacement);
                    continue;
                }
                AutoSharing.replaceComponents(comp, name, replacement, marker);
            }
        }
    }

    public static void trace(ComponentContainer container, int depth, int max) {
        int i;
        for (int i2 = 0; i2 < depth; ++i2) {
            System.err.print("\t");
        }
        System.err.println(AutoSharing.getName(container) + " = " + AutoSharing.getDefinition(container) + " {");
        List comps = container.listComponents();
        if (comps != null) {
            if (depth > max) {
                for (i = 0; i < depth; ++i) {
                    System.err.print("\t");
                }
                System.out.println("...");
            } else {
                int m = comps.size();
                for (i = 0; i < m; ++i) {
                    Component comp = (Component)comps.get(i);
                    AutoSharing.trace(comp, depth + 1, max);
                }
            }
        }
        for (i = 0; i < depth; ++i) {
            System.err.print("\t");
        }
        System.err.println("} # " + AutoSharing.getName(container));
    }
}

