/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.arguments;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.arguments.ArgumentDefinition;

public class ArgumentLoader
extends AbstractLoader {
    static final String ARG_KEY_PREFIX = " arg ";

    public Definition load(String name, Map context) throws ADLException {
        String args;
        HashMap values;
        Definition d = this.clientLoader.load(name, context);
        long tb = System.currentTimeMillis();
        HashMap hashMap = values = context == null ? new HashMap() : new HashMap(context);
        if (d instanceof ArgumentDefinition && (args = ((ArgumentDefinition)d).getArguments()) != null) {
            StringTokenizer st = new StringTokenizer(args, ",");
            int i = 0;
            while (st.hasMoreTokens()) {
                String argdef;
                String argname;
                String arg = st.nextToken();
                int j = arg.indexOf(61);
                if (j != -1) {
                    argname = arg.substring(0, j);
                    argdef = arg.substring(j + 1);
                } else {
                    argname = arg;
                    argdef = null;
                }
                Object argval = context.remove(argname);
                if (argval == null) {
                    argval = context.remove(ARG_KEY_PREFIX + i);
                }
                if (argval == null) {
                    argval = argdef;
                }
                if (argval == null) {
                    this.reportError(new ADLException("No value defined for argument '" + argname + "'", (Node)((Object)d), null));
                }
                values.put(argname, argval);
                ++i;
            }
            ((ArgumentDefinition)d).setArguments(null);
        }
        this.evaluate((Node)((Object)d), values);
        this.incrTimer(System.currentTimeMillis() - tb);
        return d;
    }

    void evaluate(Node node, Map context) throws ADLException {
        Map attrs = node.astGetAttributes();
        for (String attr : attrs.keySet()) {
            String value = (String)attrs.get(attr);
            if (value == null) continue;
            try {
                value = this.evaluate(value, context);
            }
            catch (ADLException e) {
                this.reportError(new ADLException(e.getMessage(), node, null));
            }
            attrs.put(attr, value);
        }
        node.astSetAttributes(attrs);
        String[] nodeTypes = node.astGetNodeTypes();
        for (int j = 0; j < nodeTypes.length; ++j) {
            Node[] nodes = node.astGetNodes(nodeTypes[j]);
            for (int k = 0; k < nodes.length; ++k) {
                Node n = nodes[k];
                if (n == null) continue;
                this.evaluate(n, context);
            }
        }
    }

    String evaluate(String s, Map context) throws ADLException {
        int i = s.indexOf("${");
        if (i == -1) {
            return s;
        }
        int j = s.indexOf(125, i);
        if (j == -1) {
            throw new ADLException("Malformed variable reference in '" + s + "'", null);
        }
        String arg = s.substring(i + 2, j);
        String value = (String)context.get(arg);
        if (value == null) {
            throw new ADLException("Undefined variable '" + arg + "'", null);
        }
        return this.evaluate(s.substring(0, i) + value + s.substring(j + 1), context);
    }
}

