/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.attributes;

import java.lang.reflect.Method;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.attributes.Attribute;
import org.objectweb.fractal.adl.attributes.Attributes;
import org.objectweb.fractal.adl.attributes.AttributesContainer;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.ComponentDefinition;

public class AttributeLoader
extends AbstractLoader {
    public Definition load(String name, Map context) throws ADLException {
        Definition d = this.clientLoader.load(name, context);
        long tb = System.currentTimeMillis();
        boolean extend = false;
        if (d instanceof ComponentDefinition) {
            extend = ((ComponentDefinition)d).getExtends() != null;
        }
        this.checkNode(d, extend, context, new Object());
        this.incrTimer(System.currentTimeMillis() - tb);
        return d;
    }

    private void checkNode(Object node, boolean extend, Map context, Object marker) throws ADLException {
        if (((Node)node).astSetDecoration("MARKER", marker) != marker) {
            return;
        }
        if (node instanceof AttributesContainer) {
            this.checkAttributesContainer((AttributesContainer)node, extend, context);
        }
        if (node instanceof ComponentContainer) {
            Component[] comps = ((ComponentContainer)node).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.checkNode(comps[i], extend, context, marker);
            }
        }
    }

    private void checkAttributesContainer(AttributesContainer container, boolean extend, Map context) throws ADLException {
        Attributes attrs = container.getAttributes();
        if (attrs != null) {
            String signature = attrs.getSignature();
            if (signature == null) {
                if (!extend) {
                    this.reportError(new ADLException("Signature missing", (Node)((Object)attrs)));
                    return;
                }
                return;
            }
            Class c = null;
            try {
                c = this.loadClass(context, signature);
            }
            catch (ClassNotFoundException e) {
                this.reportError(new ADLException("Invalid signature '" + signature + "'", (Node)((Object)attrs), e));
            }
            Attribute[] attributes = attrs.getAttributes();
            for (int i = 0; i < attributes.length; ++i) {
                Method getter;
                if (((Node)((Object)attributes[i])).astSetDecoration("ATTRIBUTE_CHECKED", "TRUE") != null) continue;
                String attrName = attributes[i].getName();
                String attrValue = attributes[i].getValue();
                if (attrName == null) {
                    this.reportError(new ADLException("Attribute name missing", (Node)((Object)attributes[i])));
                }
                if (attrValue == null) {
                    this.reportError(new ADLException("Attribute value missing", (Node)((Object)attributes[i])));
                }
                if (attrName == null) continue;
                try {
                    getter = this.getMethod(c, attrName);
                }
                catch (Exception e) {
                    this.reportError(new ADLException("No attribute " + attrName + " in " + c.getName(), (Node)((Object)attributes[i]), e));
                    continue;
                }
                Class<?> attrType = getter.getReturnType();
                if (attrType.isPrimitive()) {
                    if (attrType.equals(Integer.TYPE)) {
                        try {
                            Integer.valueOf(attrValue);
                        }
                        catch (NumberFormatException e) {
                            this.reportError(new ADLException("Bad integer value: " + attrValue, (Node)((Object)attributes[i])));
                        }
                        continue;
                    }
                    if (attrType.equals(Long.TYPE)) {
                        try {
                            Long.valueOf(attrValue);
                        }
                        catch (NumberFormatException e) {
                            this.reportError(new ADLException("Bad long value: " + attrValue, (Node)((Object)attributes[i])));
                        }
                        continue;
                    }
                    if (attrType.equals(Float.TYPE)) {
                        try {
                            Float.valueOf(attrValue);
                        }
                        catch (NumberFormatException e) {
                            this.reportError(new ADLException("Bad float value: " + attrValue, (Node)((Object)attributes[i])));
                        }
                        continue;
                    }
                    if (attrType.equals(Double.TYPE)) {
                        try {
                            Double.valueOf(attrValue);
                        }
                        catch (NumberFormatException e) {
                            this.reportError(new ADLException("Bad double value: " + attrValue, (Node)((Object)attributes[i])));
                        }
                        continue;
                    }
                    if (attrType.equals(Byte.TYPE)) {
                        try {
                            Byte.valueOf(attrValue);
                        }
                        catch (NumberFormatException e) {
                            this.reportError(new ADLException("Bad byte value: " + attrValue, (Node)((Object)attributes[i])));
                        }
                        continue;
                    }
                    if (attrType.equals(Character.TYPE)) {
                        if (attrValue.length() == 1) continue;
                        this.reportError(new ADLException("Bad char value: " + attrValue, (Node)((Object)attributes[i])));
                        continue;
                    }
                    if (attrType.equals(Short.TYPE)) {
                        try {
                            Short.valueOf(attrValue);
                        }
                        catch (NumberFormatException e) {
                            this.reportError(new ADLException("Bad short value: " + attrValue, (Node)((Object)attributes[i])));
                        }
                        continue;
                    }
                    if (attrType.equals(Boolean.TYPE)) {
                        if (attrValue.equals("true") || attrValue.equals("false")) continue;
                        this.reportError(new ADLException("Bad boolean value: " + attrValue, (Node)((Object)attributes[i])));
                        continue;
                    }
                    this.reportError(new ADLException("Unexpected primitive type", (Node)((Object)attributes[i])));
                    continue;
                }
                if (attrType == String.class) continue;
                this.reportError(new ADLException("Unsupported attribute type: " + attrType, (Node)((Object)attributes[i])));
            }
        }
    }

    Method getMethod(Class c, String attrName) throws Exception {
        String getterName = "get" + Character.toUpperCase(attrName.charAt(0)) + attrName.substring(1);
        return c.getMethod(getterName, new Class[0]);
    }
}

