/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.caches;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.AbstractNode;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;

public class CacheLoader
extends AbstractLoader {
    private Map cache = new HashMap();

    public Definition load(String name, Map context) throws ADLException {
        Definition d = (Definition)this.cache.get(name);
        if (d == null) {
            AbstractNode.mode = 1;
            d = this.clientLoader.load(name, context);
            AbstractNode.mode = 0;
            this.cache.put(name, d);
        }
        long tb = System.currentTimeMillis();
        AbstractNode.mode = 2;
        Definition result = (Definition)((Object)CacheLoader.cloneNode((Node)((Object)d)));
        AbstractNode.mode = 0;
        this.incrTimer(System.currentTimeMillis() - tb);
        return result;
    }

    public void cleanUpCaches() {
        super.cleanUpCaches();
        this.cache = new HashMap();
    }

    private static Node cloneNode(Node node) {
        Node newNode = node.astNewInstance();
        newNode.astSetSource(node.astGetSource());
        ((AbstractNode)newNode).astSetAttributes((AbstractNode)node);
        ((AbstractNode)newNode).astSetDecorations((AbstractNode)node);
        String[] nodeTypes = node.astGetNodeTypes();
        for (int i = 0; i < nodeTypes.length; ++i) {
            Node[] nodes = node.astGetNodes(nodeTypes[i]);
            for (int j = 0; j < nodes.length; ++j) {
                if (nodes[j] == null) continue;
                newNode.astAddNode(CacheLoader.cloneNode(nodes[j]));
            }
        }
        return newNode;
    }
}

