/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.components;

import java.util.List;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.apply.Apply;
import org.objectweb.fractal.adl.apply.ApplyContainer;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;

public class MarkSharedComponentLoader
extends AbstractLoader {
    public Definition load(String name, Map context) throws ADLException {
        Definition d = this.clientLoader.load(name, context);
        long tb = System.currentTimeMillis();
        this.setDepth((Node)((Object)d), 0);
        this.incrTimer(System.currentTimeMillis() - tb);
        return d;
    }

    protected void setDepth(Node node, int depth) {
        int i;
        List comps;
        Integer depthInteger = null;
        if (node instanceof ComponentContainer && (comps = ((ComponentContainer)((Object)node)).listComponents()) != null) {
            int m = comps.size();
            for (i = 0; i < m; ++i) {
                Component comp = (Component)comps.get(i);
                this.setDepth((Node)((Object)comp), depth + 1);
                if (!this.isShared(comp.getDefinition())) continue;
                if (depthInteger == null) {
                    depthInteger = new Integer(depth);
                }
                ((Node)((Object)comp)).astSetDecoration("DEPTH", depthInteger);
            }
        }
        if (node instanceof ApplyContainer) {
            Apply[] applies = ((ApplyContainer)((Object)node)).getApplys();
            for (i = 0; i < applies.length; ++i) {
                Node apply = (Node)((Object)applies[i]);
                if (depthInteger == null) {
                    depthInteger = new Integer(depth);
                }
                apply.astSetDecoration("DEPTH", depthInteger);
            }
        }
    }

    protected boolean isShared(String definition) {
        return definition != null && definition.indexOf(47) != -1 && definition.indexOf(40) == -1;
    }
}

