/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.components;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.ComponentHelper;

public class ResolveSharedComponentLoader
extends AbstractLoader {
    public Definition load(String name, Map context) throws ADLException {
        Definition d = this.clientLoader.load(name, context);
        long tb = System.currentTimeMillis();
        ResolveSharedComponentLoader.resolveComponentContainer(new ArrayList(), (ComponentContainer)((Object)d));
        this.incrTimer(System.currentTimeMillis() - tb);
        return d;
    }

    public static void resolveComponentContainer(List containers, ComponentContainer container) throws ADLException {
        List comps = container.listComponents();
        if (comps == null) {
            return;
        }
        containers.add(container);
        int m = comps.size();
        for (int i = 0; i < m; ++i) {
            Component component = (Component)comps.get(i);
            String definition = component.getDefinition();
            if (ResolveSharedComponentLoader.isShared(definition)) {
                component.setDefinition(null);
                if (definition.startsWith("./")) {
                    definition = definition.substring(2);
                }
                int depth = (Integer)((Node)((Object)component)).astGetDecoration("DEPTH");
                ComponentContainer root = (ComponentContainer)containers.get(containers.size() - 1 - depth);
                Component c = ComponentHelper.getPathComponent(root, definition);
                if (c == null) {
                    throw new ADLException("No such component (" + definition + " in " + ((Component)root).getName() + ")", (Node)((Object)component));
                }
                if (!c.getName().equals(component.getName())) {
                    throw new ADLException("Shared components with distinct names not yet supported", (Node)((Object)component));
                }
                comps.set(i, c);
                if (c != component && ((Node)((Object)component)).astGetDecoration("SHARED") != null) {
                    ComponentHelper.replaceComponent((ComponentContainer)containers.get(0), component, c, new Object());
                }
                ((Node)((Object)c)).astSetDecoration("SHARED", "TRUE");
                continue;
            }
            ResolveSharedComponentLoader.resolveComponentContainer(containers, component);
        }
        containers.remove(containers.size() - 1);
    }

    protected static boolean isShared(String definition) {
        return definition != null && definition.indexOf(47) != -1 && definition.indexOf(40) == -1;
    }

    protected static String getName(Object node) {
        if (node instanceof Definition) {
            return ((Definition)node).getName();
        }
        if (node instanceof Component) {
            return ((Component)node).getName();
        }
        return null;
    }

    protected static void trace(List containers, ComponentContainer root) {
        for (int i = 0; i < containers.size(); ++i) {
            ComponentContainer c = (ComponentContainer)containers.get(i);
            System.out.print(ResolveSharedComponentLoader.getName(c) + '/');
        }
        System.out.println();
    }
}

