/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.types;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.fractal.adl.types.TypeBuilder;
import org.objectweb.fractal.adl.util.ClassLoaderHelper;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.util.Fractal;

public class FractalTypeBuilder
implements TypeBuilder {
    protected Map cacheItfTypes = new HashMap();
    static int nbTimer = 0;
    static long totalTimer = 0L;

    public Object createInterfaceType(String name, String signature, String role, String contingency, String cardinality, Object context) throws Exception {
        long tb = System.currentTimeMillis();
        StringBuffer buffer = new StringBuffer();
        buffer.append(name);
        buffer.append('-');
        buffer.append(signature);
        buffer.append('-');
        buffer.append(role);
        buffer.append('-');
        buffer.append(contingency);
        buffer.append('-');
        buffer.append(cardinality);
        String key = buffer.toString();
        Object itfType = this.cacheItfTypes.get(key);
        if (itfType != null) {
            return itfType;
        }
        ClassLoader loader = ClassLoaderHelper.getClassLoader(this, context);
        Component bootstrap = null;
        if (context != null) {
            bootstrap = (Component)((Map)context).get("bootstrap");
        }
        if (bootstrap == null) {
            HashMap<String, ClassLoader> ctxt = new HashMap<String, ClassLoader>();
            ctxt.put("classloader", loader);
            bootstrap = Fractal.getBootstrapComponent(ctxt);
        }
        boolean client = "client".equals(role);
        boolean optional = "optional".equals(contingency);
        boolean collection = "collection".equals(cardinality);
        InterfaceType result = Fractal.getTypeFactory((Component)bootstrap).createFcItfType(name, signature, client, optional, collection);
        this.cacheItfTypes.put(key, result);
        FractalTypeBuilder.incrTimer(System.currentTimeMillis() - tb);
        return result;
    }

    public Object createComponentType(String name, Object[] interfaceTypes, Object context) throws Exception {
        long tb = System.currentTimeMillis();
        ClassLoader loader = ClassLoaderHelper.getClassLoader(this, context);
        Component bootstrap = null;
        if (context != null) {
            bootstrap = (Component)((Map)context).get("bootstrap");
        }
        if (bootstrap == null) {
            HashMap<String, ClassLoader> ctxt = new HashMap<String, ClassLoader>();
            ctxt.put("classloader", loader);
            bootstrap = Fractal.getBootstrapComponent(ctxt);
        }
        InterfaceType[] types = new InterfaceType[interfaceTypes.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = (InterfaceType)interfaceTypes[i];
        }
        ComponentType result = Fractal.getTypeFactory((Component)bootstrap).createFcType(types);
        FractalTypeBuilder.incrTimer(System.currentTimeMillis() - tb);
        return result;
    }

    static void incrTimer(long t) {
        totalTimer += t;
        ++nbTimer;
    }

    public static void printStats() {
        System.err.println("FractalTypeBuilder: " + totalTimer + " milliseconds in " + nbTimer + " calls.");
        nbTimer = 0;
        totalTimer = 0L;
    }
}

