/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.types;

import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.ComponentDefinition;
import org.objectweb.fractal.adl.interfaces.Interface;
import org.objectweb.fractal.adl.interfaces.InterfaceContainer;
import org.objectweb.fractal.adl.types.TypeInterface;

public class TypeLoader
extends AbstractLoader {
    public Definition load(String name, Map context) throws ADLException {
        Definition d = this.clientLoader.load(name, context);
        long tb = System.currentTimeMillis();
        boolean extend = false;
        if (d instanceof ComponentDefinition) {
            extend = ((ComponentDefinition)d).getExtends() != null;
        }
        this.checkNode(d, extend, context);
        this.incrTimer(System.currentTimeMillis() - tb);
        return d;
    }

    private void checkNode(Object node, boolean extend, Map context) throws ADLException {
        if (node instanceof InterfaceContainer) {
            this.checkInterfaceContainer((InterfaceContainer)node, extend, context);
        }
        if (node instanceof ComponentContainer) {
            Component[] comps = ((ComponentContainer)node).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.checkNode(comps[i], extend, context);
            }
        }
    }

    private void checkInterfaceContainer(InterfaceContainer container, boolean extend, Map context) throws ADLException {
        Interface[] itfs = container.getInterfaces();
        for (int i = 0; i < itfs.length; ++i) {
            String cardinality;
            String contingency;
            String role;
            Interface itf = itfs[i];
            if (!(itf instanceof TypeInterface)) continue;
            String signature = ((TypeInterface)itf).getSignature();
            if (signature == null) {
                if (!extend) {
                    this.reportError(new ADLException("Signature missing", (Node)((Object)itf)));
                }
            } else {
                try {
                    this.loadClass(context, signature);
                }
                catch (ClassNotFoundException e) {
                    this.reportError(new ADLException("Invalid signature '" + signature + "'", (Node)((Object)itf), e));
                }
            }
            if ((role = ((TypeInterface)itf).getRole()) == null) {
                if (!extend) {
                    this.reportError(new ADLException("Role missing", (Node)((Object)itf)));
                }
            } else if (!role.equals("client") && !role.equals("server")) {
                this.reportError(new ADLException("Invalid role '" + role + "'", (Node)((Object)itf)));
            }
            if ((contingency = ((TypeInterface)itf).getContingency()) != null && !contingency.equals("mandatory") && !contingency.equals("optional")) {
                this.reportError(new ADLException("Invalid contingency '" + contingency + "'", (Node)((Object)itf)));
            }
            if ((cardinality = ((TypeInterface)itf).getCardinality()) == null || cardinality.equals("singleton") || cardinality.equals("collection")) continue;
            this.reportError(new ADLException("Invalid cardinality '" + cardinality + "'", (Node)((Object)itf)));
        }
    }
}

