/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.xml;

import java.io.InputStream;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Loader;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.Parser;
import org.objectweb.fractal.adl.ParserException;
import org.objectweb.fractal.adl.util.ClassLoaderHelper;
import org.objectweb.fractal.adl.xml.XMLParser;

public class XMLLoader
implements Loader {
    private Parser parser;
    private int nbTimer = 0;
    private long totalTimer = 0L;

    public XMLLoader() {
        this(true);
    }

    public XMLLoader(boolean validate) {
        this.parser = new XMLParser(validate);
    }

    public Definition load(String name, Map context) throws ADLException {
        long tb = System.currentTimeMillis();
        try {
            String file = name.replace('.', '/') + ".fractal";
            ClassLoader cl = ClassLoaderHelper.getClassLoader(this, context);
            InputStream is = cl.getResourceAsStream(file);
            if (is == null) {
                throw new ADLException("Cannot find '" + file + "' in the classpath", null);
            }
            Definition d = (Definition)((Object)this.parser.parse(is, file));
            if (d.getName() == null) {
                throw new ADLException("Definition name missing", (Node)((Object)d));
            }
            if (!d.getName().equals(name)) {
                throw new ADLException("Wrong definition name ('" + name + "' expected, instead of '" + d.getName() + "')", (Node)((Object)d));
            }
            this.incrTimer(System.currentTimeMillis() - tb);
            return d;
        }
        catch (ParserException e) {
            throw new ADLException("Cannot load '" + name + "'", null, e);
        }
    }

    protected void incrTimer(long t) {
        this.totalTimer += t;
        ++this.nbTimer;
    }

    public long printStats(long t) {
        float p = (float)this.totalTimer / (float)t * 100.0f;
        System.err.println("XMLoader: " + this.totalTimer + " (" + p + "%) milliseconds in " + this.nbTimer + " calls.");
        long result = t - this.totalTimer;
        this.nbTimer = 0;
        this.totalTimer = 0L;
        return result;
    }

    public void cleanUpCaches() {
    }
}

