/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.xml;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.fractal.adl.NodeClassLoader;
import org.objectweb.fractal.adl.xml.XMLNode;

class XMLNodeClassLoader
extends NodeClassLoader {
    private Map astItfs = new HashMap();
    private Map astNodes = new HashMap();
    private Map xmlElements = new HashMap();
    private Map astAttributes = new HashMap();
    private Map xmlAttributes = new HashMap();
    private static final String PKG = "org.objectweb.fractal.adl.ast.xml.";

    public XMLNodeClassLoader(ClassLoader parent) {
        super(parent);
    }

    void addASTNodeInterface(String astNode, String itf) {
        HashSet<String> s = (HashSet<String>)this.astItfs.get(astNode);
        if (s == null) {
            s = new HashSet<String>();
            this.astItfs.put(astNode, s);
        }
        s.add(itf.replace('.', '/'));
    }

    void addASTNodeMapping(String astName, String xmlName) {
        this.xmlElements.put(astName, xmlName);
        this.astNodes.put(xmlName, astName);
    }

    void addASTAttributeMapping(String astName, String xmlName) {
        this.xmlAttributes.put(astName, xmlName.substring(xmlName.indexOf(46) + 1));
        this.astAttributes.put(xmlName, astName.substring(astName.indexOf(46) + 1));
    }

    String getASTName(String xmlElement) {
        String astName = (String)this.astNodes.get(xmlElement);
        return astName == null ? xmlElement : astName;
    }

    String getXMLElement(String astNode) {
        String xmlElement = (String)this.xmlElements.get(astNode);
        return xmlElement == null ? astNode : xmlElement;
    }

    String getASTAttribute(String xmlNode, String xmlAttr) {
        String astAttribute = (String)this.astAttributes.get(xmlNode + "." + xmlAttr);
        return astAttribute == null ? xmlAttr : astAttribute;
    }

    String getXMLAttribute(String astNode, String astAttr) {
        String xmlAttribute = (String)this.xmlAttributes.get(astNode + "." + astAttr);
        return xmlAttribute == null ? astAttr : xmlAttribute;
    }

    String getASTClassName(String xmlElement) {
        String astNode = (String)this.astNodes.get(xmlElement);
        if (astNode == null) {
            astNode = xmlElement;
        }
        return XMLNodeClassLoader.getASTClass(astNode);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (XMLNodeClassLoader.isASTClass(name)) {
            byte[] b = this.generateClass(XMLNodeClassLoader.getASTNode(name));
            return this.defineClass(name, b);
        }
        return super.findClass(name);
    }

    private byte[] generateClass(String astNodeName) throws ClassNotFoundException {
        String owner = XMLNodeClassLoader.getASTClass(astNodeName).replace('.', '/');
        String xmlNode = Type.getInternalName(XMLNode.class);
        Set itfSet = (Set)this.astItfs.get(astNodeName);
        String[] itfs = itfSet.toArray(new String[itfSet.size()]);
        ClassWriter cw = this.generateClass(this.getASTClassName(astNodeName), astNodeName, xmlNode, itfs);
        MethodVisitor xsa = cw.visitMethod(1, "xmlSetAttributes", "(Lorg/xml/sax/Attributes;)V", null, null);
        MethodVisitor xan = cw.visitMethod(1, "xmlAddNode", "(Ljava/lang/String;L" + xmlNode + ";)V", null, null);
        Label xanEnd = new Label();
        HashSet<String> methods = new HashSet<String>();
        for (int i = 0; i < itfs.length; ++i) {
            Method[] meths = this.loadClass(itfs[i].replace('/', '.')).getMethods();
            for (int j = 0; j < meths.length; ++j) {
                String fieldDesc;
                Method meth = meths[j];
                String name = meth.getName();
                String desc = Type.getMethodDescriptor((Method)meth);
                if (methods.contains(name + desc)) continue;
                methods.add(name + desc);
                if (!name.startsWith("get")) continue;
                String field = XMLNodeClassLoader.getFieldName(name, 3);
                if (desc.startsWith("()[")) {
                    fieldDesc = "Ljava/util/List;";
                    this.generateAddNodesMethod(xan, owner, name, field, fieldDesc, xanEnd, true);
                    continue;
                }
                fieldDesc = desc.substring(2);
                if (fieldDesc.equals("Ljava/lang/String;")) {
                    xsa.visitVarInsn(25, 0);
                    xsa.visitVarInsn(25, 1);
                    xsa.visitLdcInsn((Object)this.getXMLAttribute(astNodeName, XMLNodeClassLoader.getASTName(name, true)));
                    xsa.visitMethodInsn(185, "org/xml/sax/Attributes", "getValue", "(Ljava/lang/String;)Ljava/lang/String;");
                    xsa.visitFieldInsn(181, owner, field, fieldDesc);
                    continue;
                }
                this.generateAddNodeMethod(xan, owner, name, field, fieldDesc, xanEnd, true);
            }
        }
        xsa.visitInsn(177);
        xsa.visitMaxs(0, 0);
        xan.visitLabel(xanEnd);
        xan.visitInsn(177);
        xan.visitMaxs(0, 0);
        return cw.toByteArray();
    }

    private void generateAddNodeMethod(MethodVisitor cv, String owner, String name, String field, String fieldDesc, Label end, boolean add) {
        String s = XMLNodeClassLoader.getASTName(name, true);
        Label l = this.generateIf(cv, this.getXMLElement(s));
        cv.visitVarInsn(25, 0);
        if (add) {
            cv.visitVarInsn(25, 2);
            cv.visitTypeInsn(192, fieldDesc.substring(1, fieldDesc.length() - 1));
        } else {
            cv.visitInsn(1);
        }
        cv.visitFieldInsn(181, owner, field, fieldDesc);
        cv.visitJumpInsn(167, end);
        cv.visitLabel(l);
    }

    private void generateAddNodesMethod(MethodVisitor cv, String owner, String name, String field, String fieldDesc, Label end, boolean add) {
        String s = XMLNodeClassLoader.getASTName(name, false);
        Label l = this.generateIf(cv, this.getXMLElement(s));
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, owner, field, fieldDesc);
        Label ln = new Label();
        cv.visitJumpInsn(199, ln);
        cv.visitVarInsn(25, 0);
        cv.visitTypeInsn(187, "java/util/ArrayList");
        cv.visitInsn(89);
        cv.visitInsn(4);
        cv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "(I)V");
        cv.visitFieldInsn(181, owner, field, fieldDesc);
        cv.visitLabel(ln);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, owner, field, fieldDesc);
        cv.visitVarInsn(25, 2);
        cv.visitMethodInsn(185, "java/util/List", add ? "add" : "remove", add ? "(Ljava/lang/Object;)Z" : "(Ljava/lang/Object;)Z");
        cv.visitInsn(87);
        cv.visitJumpInsn(167, end);
        cv.visitLabel(l);
    }

    private Label generateIf(MethodVisitor cv, String name) {
        Label l = new Label();
        cv.visitVarInsn(25, 1);
        cv.visitLdcInsn((Object)name);
        cv.visitMethodInsn(182, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z");
        cv.visitJumpInsn(153, l);
        return l;
    }

    private static String getASTClass(String astNodeName) {
        return PKG + astNodeName + "Impl";
    }

    private static boolean isASTClass(String name) {
        return name.startsWith(PKG) && name.endsWith("Impl");
    }

    private static String getASTNode(String astClassName) {
        return astClassName.substring(PKG.length(), astClassName.length() - 4);
    }
}

