/*
 * Decompiled with CFR 0.152.
 */
package thor.app;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.io.IOException;
import thor.app.BasicTelnet;
import thor.net.DefaultTelnetTerminalHandler;

public class VT100Telnet
extends BasicTelnet {
    static final int maxInt = Integer.MAX_VALUE;
    int begScroll;
    int endScroll;
    int[] tabStop;
    static byte[] ansiUp = new byte[]{27, 91, 65};
    static byte[] ansiDown = new byte[]{27, 91, 66};
    static byte[] ansiRight = new byte[]{27, 91, 67};
    static byte[] ansiLeft = new byte[]{27, 91, 68};
    static final int CASE_GROUND_STATE = 0;
    static final int CASE_IGNORE_STATE = 1;
    static final int CASE_IGNORE_ESC = 2;
    static final int CASE_IGNORE = 3;
    static final int CASE_BELL = 4;
    static final int CASE_BS = 5;
    static final int CASE_CR = 6;
    static final int CASE_ESC = 7;
    static final int CASE_VMOT = 8;
    static final int CASE_TAB = 9;
    static final int CASE_SI = 10;
    static final int CASE_SO = 11;
    static final int CASE_SCR_STATE = 12;
    static final int CASE_SCS0_STATE = 13;
    static final int CASE_SCS1_STATE = 14;
    static final int CASE_SCS2_STATE = 15;
    static final int CASE_SCS3_STATE = 16;
    static final int CASE_ESC_IGNORE = 17;
    static final int CASE_ESC_DIGIT = 18;
    static final int CASE_ESC_SEMI = 19;
    static final int CASE_DEC_STATE = 20;
    static final int CASE_ICH = 21;
    static final int CASE_CUU = 22;
    static final int CASE_CUD = 23;
    static final int CASE_CUF = 24;
    static final int CASE_CUB = 25;
    static final int CASE_CUP = 26;
    static final int CASE_ED = 27;
    static final int CASE_EL = 28;
    static final int CASE_IL = 29;
    static final int CASE_DL = 30;
    static final int CASE_DCH = 31;
    static final int CASE_DA1 = 32;
    static final int CASE_TRACK_MOUSE = 33;
    static final int CASE_TBC = 34;
    static final int CASE_SET = 35;
    static final int CASE_RST = 36;
    static final int CASE_SGR = 37;
    static final int CASE_CPR = 38;
    static final int CASE_DECSTBM = 39;
    static final int CASE_DECREQTPARM = 40;
    static final int CASE_DECSET = 41;
    static final int CASE_DECRST = 42;
    static final int CASE_DECALN = 43;
    static final int CASE_GSETS = 44;
    static final int CASE_DECSC = 45;
    static final int CASE_DECRC = 46;
    static final int CASE_DECKPAM = 47;
    static final int CASE_DECKPNM = 48;
    static final int CASE_IND = 49;
    static final int CASE_NEL = 50;
    static final int CASE_HTS = 51;
    static final int CASE_RI = 52;
    static final int CASE_SS2 = 53;
    static final int CASE_SS3 = 54;
    static final int CASE_CSI_STATE = 55;
    static final int CASE_OSC = 56;
    static final int CASE_RIS = 57;
    static final int CASE_LS2 = 58;
    static final int CASE_LS3 = 59;
    static final int CASE_LS3R = 60;
    static final int CASE_LS2R = 61;
    static final int CASE_LS1R = 62;
    static final int CASE_PRINT = 63;
    static final int CASE_XTERM_SAVE = 64;
    static final int CASE_XTERM_RESTORE = 65;
    static final int CASE_XTERM_TITLE = 66;
    static final int CASE_DECID = 67;
    static final int CASE_HP_MEM_LOCK = 68;
    static final int CASE_HP_MEM_UNLOCK = 69;
    static final int CASE_HP_BUGGY_LL = 70;
    static final int CASE_NUL = 71;
    static final int DEFAULT = -1;
    int nparam;
    int[] param;
    int[] parseState;
    int row;
    int col;
    int top;
    int bot;
    int saveX;
    int saveY;
    int scstype;
    int curss;
    int curgl;
    int curgr;
    static int[] groundtable = new int[]{71, 63, 63, 63, 63, 63, 63, 4, 5, 9, 8, 8, 8, 6, 11, 10, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 7, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 0, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63};
    static int[] csitable = new int[]{3, 3, 3, 3, 3, 3, 3, 4, 5, 9, 8, 8, 8, 6, 11, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 7, 3, 3, 3, 3, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 3, 19, 3, 3, 3, 20, 21, 22, 23, 24, 25, 0, 0, 0, 26, 0, 27, 28, 29, 30, 0, 0, 31, 0, 0, 0, 33, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 26, 34, 35, 0, 0, 0, 36, 37, 38, 0, 0, 0, 39, 45, 0, 46, 0, 0, 40, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static int[] dectable = new int[]{3, 3, 3, 3, 3, 3, 3, 4, 5, 9, 8, 8, 8, 6, 11, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 7, 3, 3, 3, 3, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 3, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 41, 0, 0, 0, 42, 0, 0, 0, 0, 0, 65, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static int[] eigtable = new int[]{3, 3, 3, 3, 3, 3, 3, 4, 5, 9, 8, 8, 8, 6, 11, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 7, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static int[] esctable = new int[]{3, 3, 3, 3, 3, 3, 3, 4, 5, 9, 8, 8, 8, 6, 11, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 7, 3, 3, 3, 3, 17, 17, 17, 12, 17, 17, 17, 17, 13, 14, 15, 16, 17, 17, 17, 17, 0, 0, 0, 0, 0, 0, 0, 45, 46, 0, 0, 0, 0, 47, 48, 0, 0, 0, 0, 0, 49, 50, 70, 0, 51, 0, 0, 0, 0, 52, 53, 54, 1, 0, 0, 0, 66, 0, 0, 0, 0, 0, 67, 55, 0, 56, 1, 1, 0, 0, 0, 57, 0, 0, 0, 0, 0, 0, 0, 0, 68, 69, 58, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 60, 61, 62, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static int[] iestable = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static int[] igntable = new int[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 0, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static int[] scrtable = new int[]{3, 3, 3, 3, 3, 3, 3, 4, 5, 9, 8, 8, 8, 6, 11, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 7, 3, 3, 3, 3, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 0, 0, 0, 0, 0, 0, 0, 0, 43, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static int[] scstable = new int[]{3, 3, 3, 3, 3, 3, 3, 4, 5, 9, 8, 8, 8, 6, 11, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 7, 3, 3, 3, 3, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 44, 44, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 44, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public static void main(String[] stringArray) {
        try {
            String string = stringArray.length > 0 ? stringArray[0] : "graphics.nyu.edu";
            int n = stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : 23;
            VT100Telnet vT100Telnet = new VT100Telnet(string, n);
            Frame frame = new Frame(string){

                public void update(Graphics graphics) {
                }

                public void paint(Graphics graphics) {
                }
            };
            frame.setLayout(new BorderLayout());
            frame.add((Component)vT100Telnet, "Center");
            frame.setResizable(false);
            frame.pack();
            frame.show();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean keyUp(Event event, int n) {
        if (n < 1000) {
            try {
                this.sOut.write((byte)n);
            }
            catch (Exception exception) {}
        } else {
            byte[] byArray = new byte[]{};
            switch (n) {
                case 1004: {
                    byArray = ansiUp;
                    break;
                }
                case 1005: {
                    byArray = ansiDown;
                    break;
                }
                case 1006: {
                    byArray = ansiLeft;
                    break;
                }
                case 1007: {
                    byArray = ansiRight;
                    break;
                }
                default: {
                    System.out.println("key...");
                    System.out.println(n);
                }
            }
            try {
                this.sOut.write(byArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    void VTReset() {
        this.initProcess();
        this.begScroll = 0;
        this.nparam = 0;
        this.saveX = 0;
        this.saveY = 0;
        this.scstype = 0;
        this.curss = 0;
        this.curgl = 0;
        this.curgr = 0;
    }

    public void initProcess() {
        this.wrap = false;
        this.parseState = groundtable;
        this.param = new int[10];
        int n = 0;
        while (n < 10) {
            this.param[n] = -1;
            ++n;
        }
        this.tabStop = new int[100];
        int n2 = 0;
        while (n2 < 10) {
            this.tabStop[n2] = n2 * 8;
            ++n2;
        }
        int n3 = 10;
        while (n3 < 100) {
            this.tabStop[n3] = Integer.MAX_VALUE;
            ++n3;
        }
        this.endScroll = 24;
    }

    public VT100Telnet(String string) throws IOException {
        this(string, 23);
    }

    public VT100Telnet(String string, int n) throws IOException {
        super(string, n);
        this.telnetHandler = new VT100TelnetTerminalHandler();
    }

    public void tabClear() {
        int n = 0;
        while (n < 99) {
            this.tabStop[n] = Integer.MAX_VALUE;
            ++n;
        }
    }

    public void tabSet() {
        int n = 0;
        while (this.xloc > this.tabStop[n]) {
            ++n;
        }
        if (this.xloc == this.tabStop[n]) {
            return;
        }
        if (this.tabStop[n] < Integer.MAX_VALUE) {
            int n2 = 99;
            while (n2 < n) {
                this.tabStop[n2] = this.tabStop[n2 - 1];
                --n2;
            }
        }
        this.tabStop[n] = this.xloc;
    }

    public void tabZonk() {
        this.tabClear();
    }

    public int tabNext(int n) {
        int n2 = 0;
        while (n >= this.tabStop[n2]) {
            ++n2;
        }
        int n3 = 79 < this.tabStop[n2] ? 79 : this.tabStop[n2];
        return n3;
    }

    void scrollRegionDown(int n, int n2) {
        int n3 = n2;
        while (n3 > n) {
            this.screen[n3] = this.screen[n3 - 1];
            this.screenfg[n3] = this.screenfg[n3 - 1];
            this.screenbg[n3] = this.screenbg[n3 - 1];
            this.lineRedraw[n3] = true;
            --n3;
        }
        this.screen[n] = new char[80];
        this.screenfg[n] = new Color[80];
        this.screenbg[n] = new Color[80];
        int n4 = 0;
        while (n4 < 80) {
            this.screenfg[n][n4] = this.fgcolor;
            this.screenbg[n][n4] = this.bgcolor;
            ++n4;
        }
        this.lineRedraw[n] = true;
    }

    void scrollRegionUp(int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            this.screen[n3] = this.screen[n3 + 1];
            this.screenfg[n3] = this.screenfg[n3 + 1];
            this.screenbg[n3] = this.screenbg[n3 + 1];
            this.lineRedraw[n3] = true;
            ++n3;
        }
        this.screen[n2] = new char[80];
        this.screenfg[n2] = new Color[80];
        this.screenbg[n2] = new Color[80];
        int n4 = 0;
        while (n4 < 80) {
            this.screenfg[n2][n4] = this.fgcolor;
            this.screenbg[n2][n4] = this.bgcolor;
            ++n4;
        }
        this.lineRedraw[n2] = true;
    }

    /*
     * Unable to fully structure code
     */
    public void insertLine(int var1_1) {
        if (this.yloc > this.begScroll && this.yloc < this.endScroll) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            this.scrollRegionDown(this.begScroll, this.endScroll);
            --var1_1;
lbl5:
            // 2 sources

            ** while (0 < var1_1)
        }
lbl6:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    public void deleteLine(int var1_1) {
        if (this.yloc > this.begScroll && this.yloc < this.endScroll) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            this.scrollRegionUp(this.begScroll, this.endScroll);
            --var1_1;
lbl5:
            // 2 sources

            ** while (0 < var1_1)
        }
lbl6:
        // 1 sources

    }

    public void deleteChar(int n) {
        int n2 = this.xloc;
        n = n + this.xloc < 80 ? n + this.xloc : 80;
        while (this.xloc < n) {
            this.normal((byte)32);
        }
        this.xloc = n2;
    }

    public void insertChar(int n) {
        int n2 = this.xloc;
        while (n2 < n && n2 < 79) {
            this.normal((byte)32);
            ++n2;
        }
    }

    public void trackMouse(int n, int n2, int n3, int n4, int n5) {
    }

    public void cursorSet(int n, int n2) {
        this.yloc = n;
        this.xloc = n2;
        if (this.yloc >= 24) {
            this.yloc = 23;
        }
        if (this.xloc >= 80) {
            this.xloc = 79;
        }
        if (this.yloc < 0) {
            this.yloc = 0;
        }
        if (this.xloc < 0) {
            this.xloc = 0;
        }
    }

    public void process(byte by) {
        switch (this.parseState[by & 0xFF]) {
            case 63: {
                this.normal(by);
                break;
            }
            case 0: {
                this.parseState = groundtable;
                break;
            }
            case 1: {
                this.parseState = igntable;
                break;
            }
            case 2: {
                this.parseState = iestable;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                --this.xloc;
                if (this.xloc >= 0) break;
                --this.yloc;
                this.xloc = 79;
                if (this.yloc >= 0) break;
                this.yloc = 0;
                break;
            }
            case 6: {
                this.xloc = 0;
                this.parseState = groundtable;
                break;
            }
            case 71: {
                break;
            }
            case 7: {
                this.parseState = esctable;
                break;
            }
            case 8: {
                ++this.yloc;
                this.scrValid();
                this.lineRedraw[this.yloc] = true;
                this.parseState = groundtable;
                break;
            }
            case 9: {
                this.xloc = this.tabNext(this.xloc);
                break;
            }
            case 10: {
                this.curgl = 0;
                break;
            }
            case 11: {
                this.curgl = 1;
                break;
            }
            case 12: {
                this.parseState = scrtable;
                break;
            }
            case 13: {
                this.scstype = 0;
                this.parseState = scstable;
                break;
            }
            case 14: {
                this.scstype = 1;
                this.parseState = scstable;
                break;
            }
            case 15: {
                this.scstype = 2;
                this.parseState = scstable;
                break;
            }
            case 16: {
                this.scstype = 3;
                this.parseState = scstable;
                break;
            }
            case 17: {
                this.parseState = eigtable;
                break;
            }
            case 18: {
                this.row = this.param[this.nparam - 1];
                if (this.row == -1) {
                    this.row = 0;
                }
                this.param[this.nparam - 1] = 10 * this.row + (by - 48);
                break;
            }
            case 19: {
                this.param[this.nparam++] = -1;
                break;
            }
            case 20: {
                this.parseState = dectable;
                break;
            }
            case 21: {
                this.row = this.param[0];
                if (this.row < 1) {
                    this.row = 1;
                }
                this.insertChar(this.row);
                this.parseState = groundtable;
                break;
            }
            case 22: {
                this.yloc = this.param[0] < 1 ? --this.yloc : (this.yloc -= this.param[0]);
                if (this.yloc < 0) {
                    this.yloc = 0;
                }
                this.parseState = groundtable;
                break;
            }
            case 23: {
                this.yloc = this.param[0] < 1 ? ++this.yloc : (this.yloc += this.param[0]);
                if (this.yloc >= 24) {
                    this.yloc = 23;
                }
                this.parseState = groundtable;
                break;
            }
            case 24: {
                this.xloc = this.param[0] < 1 ? ++this.xloc : (this.xloc += this.param[0]);
                if (this.xloc >= 80) {
                    this.xloc = 79;
                }
                this.parseState = groundtable;
                break;
            }
            case 25: {
                this.xloc = this.param[0] < 1 ? --this.xloc : (this.xloc -= this.param[0]);
                if (this.xloc < 0) {
                    this.xloc = 0;
                }
                this.parseState = groundtable;
                break;
            }
            case 26: {
                this.row = this.param[0];
                if (this.row < 1) {
                    this.row = 1;
                }
                if (this.nparam < 2 || (this.col = this.param[1]) < 1) {
                    this.col = 1;
                }
                this.cursorSet(this.row - 1, this.col - 1);
                this.parseState = groundtable;
                break;
            }
            case 70: {
                this.cursorSet(23, 0);
                this.parseState = groundtable;
                break;
            }
            case 27: {
                switch (this.param[0]) {
                    case -1: 
                    case 0: {
                        this.clearLines(this.yloc, 23);
                        break;
                    }
                    case 1: {
                        this.clearLines(0, this.yloc - 1);
                        break;
                    }
                    case 2: {
                        this.clearLines(0, 23);
                        this.xloc = 0;
                        this.yloc = 0;
                    }
                }
                this.parseState = groundtable;
                break;
            }
            case 28: {
                switch (this.param[0]) {
                    case -1: 
                    case 0: {
                        this.clearLine(this.xloc, 79);
                        break;
                    }
                    case 1: {
                        this.clearLine(0, this.xloc - 1);
                        break;
                    }
                    case 2: {
                        this.clearLine(0, 79);
                    }
                }
                this.parseState = groundtable;
                break;
            }
            case 29: {
                this.row = this.param[0];
                if (this.row < 1) {
                    this.row = 1;
                }
                this.insertLine(this.row);
                this.parseState = groundtable;
                break;
            }
            case 30: {
                this.row = this.param[0];
                if (this.row < 1) {
                    this.row = 1;
                }
                this.deleteLine(this.row);
                this.parseState = groundtable;
                break;
            }
            case 31: {
                this.row = this.param[0];
                if (this.row < 1) {
                    this.row = 1;
                }
                this.deleteChar(this.row);
                this.parseState = groundtable;
                break;
            }
            case 33: {
                this.trackMouse(this.param[0], this.param[2] - 1, this.param[1] - 1, this.param[3] - 1, this.param[4] - 2);
                break;
            }
            case 67: {
                this.param[0] = -1;
            }
            case 32: {
                if (this.param[0] <= 0) {
                    // empty if block
                }
                this.parseState = groundtable;
                break;
            }
            case 34: {
                this.row = this.param[0];
                if (this.row <= 0) {
                    this.tabClear();
                } else if (this.row == 3) {
                    this.tabZonk();
                }
                this.parseState = groundtable;
                break;
            }
            case 35: {
                this.parseState = groundtable;
                break;
            }
            case 36: {
                this.parseState = groundtable;
                break;
            }
            case 37: {
                this.rendition(this.param, this.nparam);
                this.parseState = groundtable;
                break;
            }
            case 38: {
                this.row = this.param[0];
                if (this.row == 5 || this.row == 6) {
                    // empty if block
                }
                this.parseState = groundtable;
                break;
            }
            case 68: 
            case 69: {
                this.begScroll = this.parseState[by] == 68 ? this.yloc : 0;
                this.parseState = groundtable;
                break;
            }
            case 39: {
                this.top = this.param[0];
                if (this.top < 1) {
                    this.top = 1;
                }
                if (this.nparam < 2 || (this.bot = this.param[1]) == -1 || this.bot > 25 || this.bot == 0) {
                    this.bot = 25;
                }
                if (this.bot > this.top) {
                    this.begScroll = this.top - 1;
                    this.endScroll = this.bot - 1;
                    this.cursorSet(0, 0);
                }
                this.parseState = groundtable;
                break;
            }
            case 40: {
                this.row = this.param[0];
                if (this.row == -1) {
                    this.row = 0;
                }
                if (this.row == 0 || this.row == 1) {
                    // empty if block
                }
                this.parseState = groundtable;
                break;
            }
            case 41: {
                this.parseState = groundtable;
                break;
            }
            case 42: {
                this.parseState = groundtable;
                break;
            }
            case 43: {
                this.parseState = groundtable;
                break;
            }
            case 44: {
                this.parseState = groundtable;
                break;
            }
            case 45: {
                this.saveX = this.xloc;
                this.saveY = this.yloc;
                this.parseState = groundtable;
                break;
            }
            case 46: {
                this.xloc = this.saveX;
                this.yloc = this.saveY;
                this.parseState = groundtable;
                break;
            }
            case 47: {
                this.parseState = groundtable;
                break;
            }
            case 48: {
                this.parseState = groundtable;
                break;
            }
            case 49: {
                this.parseState = groundtable;
                break;
            }
            case 50: {
                this.parseState = groundtable;
                break;
            }
            case 51: {
                this.tabSet();
                this.parseState = groundtable;
                break;
            }
            case 52: {
                this.parseState = groundtable;
                break;
            }
            case 53: {
                this.curss = 2;
                this.parseState = groundtable;
                break;
            }
            case 54: {
                this.curss = 3;
                this.parseState = groundtable;
                break;
            }
            case 55: {
                this.nparam = 1;
                this.param[0] = -1;
                this.parseState = csitable;
                break;
            }
            case 56: {
                this.parseState = groundtable;
                break;
            }
            case 57: {
                this.VTReset();
                this.parseState = groundtable;
                break;
            }
            case 58: {
                this.curgl = 2;
                this.parseState = groundtable;
                break;
            }
            case 59: {
                this.curgl = 3;
                this.parseState = groundtable;
                break;
            }
            case 60: {
                this.curgr = 3;
                this.parseState = groundtable;
                break;
            }
            case 61: {
                this.curgr = 2;
                this.parseState = groundtable;
                break;
            }
            case 62: {
                this.curgr = 1;
                this.parseState = groundtable;
                break;
            }
            case 64: {
                this.parseState = groundtable;
                break;
            }
            case 65: {
                this.parseState = groundtable;
            }
        }
    }

    void rendition(int[] nArray, int n) {
        if (n <= 0) {
            nArray[0] = 0;
            n = 1;
        }
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] < 10) {
                switch (nArray[n2]) {
                    case -1: 
                    case 0: {
                        this.fgcolor = Color.black;
                        this.bgcolor = Color.white;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 7: {
                        Color color = this.fgcolor;
                        this.fgcolor = this.bgcolor;
                        this.bgcolor = color;
                        break;
                    }
                    case 8: {
                        this.fgcolor = this.bgcolor;
                    }
                }
            } else if (nArray[n2] < 40) {
                switch (nArray[n2]) {
                    default: 
                }
            } else {
                switch (nArray[n2]) {
                    default: 
                }
            }
            ++n2;
        }
    }

    void clearLines(int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            this.lineRedraw[n3] = true;
            int n4 = 0;
            while (n4 < 80) {
                this.screen[n3][n4] = 32;
                this.screenfg[n3][n4] = this.fgcolor;
                this.screenbg[n3][n4] = this.bgcolor;
                ++n4;
            }
            ++n3;
        }
    }

    void clearLine(int n, int n2) {
        this.lineRedraw[this.yloc] = true;
        int n3 = n;
        while (n3 <= n2) {
            this.screen[this.yloc][n3] = 32;
            this.screenfg[this.yloc][n3] = this.fgcolor;
            this.screenbg[this.yloc][n3] = this.bgcolor;
            ++n3;
        }
    }

    class VT100TelnetTerminalHandler
    extends DefaultTelnetTerminalHandler {
        VT100TelnetTerminalHandler() {
        }

        public void LineFeed() {
            VT100Telnet.this.lineRedraw[VT100Telnet.this.yloc] = true;
            ++VT100Telnet.this.yloc;
            VT100Telnet.this.scrValid();
            VT100Telnet.this.lineRedraw[VT100Telnet.this.yloc] = true;
        }

        public void BackSpace() {
            --VT100Telnet.this.xloc;
            if (VT100Telnet.this.xloc < 0) {
                VT100Telnet.this.lineRedraw[VT100Telnet.this.yloc] = true;
                --VT100Telnet.this.yloc;
                VT100Telnet.this.xloc = 79;
                if (VT100Telnet.this.yloc < 0) {
                    VT100Telnet.this.yloc = 0;
                }
            }
            VT100Telnet.this.scrValid();
            VT100Telnet.this.lineRedraw[VT100Telnet.this.yloc] = true;
        }

        public void HorizontalTab() {
            int n = 8 - VT100Telnet.this.xloc % 8;
            int n2 = 0;
            while (n2 < n) {
                VT100Telnet.this.normal((byte)32);
                ++n2;
            }
        }

        public void CarriageReturn() {
            VT100Telnet.this.xloc = 0;
            VT100Telnet.this.scrValid();
            VT100Telnet.this.lineRedraw[VT100Telnet.this.yloc] = true;
        }

        public void Null() {
        }

        public void FormFeed() {
        }

        public void ClearScreen() {
            VT100Telnet.this.clearLines(0, VT100Telnet.this.yloc - 1);
        }

        public void VerticalTab() {
        }
    }
}

