/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.adl.apply;

import java.util.List;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.apply.Applier;
import org.objectweb.fractal.adl.apply.ApplyContext;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.ComponentHelper;

public class ShareComponents
implements Applier {
    protected String definitionToShare;

    public void apply(ApplyContext context) throws ADLException {
        ComponentContainer currentComponentContainer = (ComponentContainer)context.getCurrentNode();
        String sharedDefinition = this.definitionToShare;
        if (sharedDefinition.startsWith("./")) {
            sharedDefinition = sharedDefinition.substring(2);
        }
        if (sharedDefinition.endsWith("*")) {
            ComponentContainer sharedComponentContainer = null;
            if (sharedDefinition.endsWith("/*")) {
                sharedDefinition = sharedDefinition.substring(0, sharedDefinition.length() - 2);
                sharedComponentContainer = ComponentHelper.getPathComponent((ComponentContainer)currentComponentContainer, (String)sharedDefinition);
            } else {
                sharedComponentContainer = currentComponentContainer;
            }
            if (sharedComponentContainer == null) {
                throw new ADLException("No such component (" + this.definitionToShare + ")", (Node)context.getApply());
            }
            Component[] components = sharedComponentContainer.getComponents();
            for (int c = 0; c < components.length; ++c) {
                Component component = components[c];
                ((Node)component).astSetDecoration("SHARED", (Object)"TRUE");
                ShareComponents.replaceComponents(currentComponentContainer, component.getName(), component);
            }
        } else {
            Component sharedComponent = ComponentHelper.getPathComponent((ComponentContainer)currentComponentContainer, (String)sharedDefinition);
            if (sharedComponent == null) {
                throw new ADLException("No such component (" + this.definitionToShare + ")", (Node)context.getApply());
            }
            ((Node)sharedComponent).astSetDecoration("SHARED", (Object)"TRUE");
            ShareComponents.replaceComponents(currentComponentContainer, sharedComponent.getName(), sharedComponent);
        }
    }

    public static void replaceComponents(ComponentContainer container, String name, Component replacement) {
        List components = container.listComponents();
        if (components != null) {
            int m = components.size();
            for (int i = 0; i < m; ++i) {
                Component component = (Component)components.get(i);
                if (name.equals(component.getName())) {
                    components.set(i, replacement);
                    continue;
                }
                ShareComponents.replaceComponents((ComponentContainer)component, name, replacement);
            }
        }
    }
}

