/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.components.deployment.lib.common;

import org.objectweb.fdf.components.deployment.api.Deployment;
import org.objectweb.fdf.util.logging.AbstractLogging;

public class BasicDeployment
extends AbstractLogging
implements Deployment {
    private Deployment.Status currentStatus;

    private void updateStatus(Deployment.Status status, String msg) {
        this.currentStatus = status;
        this.info(msg);
    }

    protected void installing() {
        this.updateStatus(Deployment.Status.INSTALLING, "install begin");
    }

    protected void starting() {
        this.updateStatus(Deployment.Status.STARTING, "start begin");
    }

    protected void stopping() {
        this.updateStatus(Deployment.Status.STOPPING, "stop begin");
    }

    protected void uninstalling() {
        this.updateStatus(Deployment.Status.UNINSTALLING, "uninstall begin");
    }

    protected BasicDeployment() {
        this.currentStatus = Deployment.Status.UNKNOWN;
    }

    protected BasicDeployment(Deployment.Status status) {
        this.currentStatus = status;
    }

    protected String getWhoIAm() {
        return this.currentStatus.toString();
    }

    public Deployment.Status getStatus() {
        return this.currentStatus;
    }

    public void install() {
        this.updateStatus(Deployment.Status.INSTALLED, "install done");
    }

    public void start() {
        this.updateStatus(Deployment.Status.STARTED, "start done");
    }

    public void stop() {
        this.updateStatus(Deployment.Status.INSTALLED, "stop done");
    }

    public void uninstall() {
        this.updateStatus(Deployment.Status.UNINSTALLED, "uninstall done");
    }
}

