/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.components.petals.lib;

import java.io.IOException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import org.objectweb.fdf.components.deployment.api.Deployment;
import org.objectweb.fdf.components.petals.util.JBIJMXConnectorUtil;
import org.objectweb.fdf.components.util.api.Formatter;
import org.objectweb.fdf.util.logging.AbstractLogging;

public abstract class AbstractJBIComponent
extends AbstractLogging {
    protected String file;
    protected String host;
    protected String port;
    protected String userName;
    protected String password;
    protected Formatter formatter;
    protected Deployment.Status status = Deployment.Status.UNINSTALLED;

    protected void formatAttributes() {
        this.file = this.formatter.format(this.file);
        this.host = this.formatter.format(this.host);
        this.port = this.formatter.format(this.port);
        this.userName = this.formatter.format(this.userName);
        this.password = this.formatter.format(this.password);
    }

    protected JMXConnector getJMXConnector() {
        try {
            return JBIJMXConnectorUtil.getConnection(this.host, this.port, this.userName, this.password);
        }
        catch (IOException e) {
            this.error(new Error("AbstractJBIComponent - unable to get JMX connector", e));
            return null;
        }
    }

    protected MBeanServerConnection getMBeanServerConnection(JMXConnector connector) {
        try {
            return connector.getMBeanServerConnection();
        }
        catch (IOException e) {
            this.error(new Error("AbstractJBIComponent - unable to get MBean server connection", e));
            return null;
        }
    }

    protected Object invoke(MBeanServerConnection connection, ObjectName name, String operationName, Object[] params, String[] signature) {
        try {
            return connection.invoke(name, operationName, params, signature);
        }
        catch (Exception e) {
            this.error(new Error("AbstractJBIComponent - unable to " + operationName + " JBI component", e));
            return null;
        }
    }

    protected void closeConnector(JMXConnector connector) {
        try {
            connector.close();
        }
        catch (IOException e) {
            this.error(new Error("AbstractJBIComponent - unable to close JMX connector ", e));
        }
    }
}

