/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.components.petals.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public final class JBIJMXConnectorUtil {
    private static final String PETALS_DOMAIN = "Petals";
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String SERVICE_TYPE = "service";
    private static final String ADMIN_NAME = "Admin";
    private static final String INSTALLATION_NAME = "Installation";
    private static final String DEPLOYMENT_NAME = "Deployment";

    private JBIJMXConnectorUtil() {
    }

    public static ObjectName getAdminServiceMBeanName(MBeanServerConnection mBeanServer) throws IOException, MalformedObjectNameException, NullPointerException {
        ObjectName result = null;
        Hashtable<String, String> attributes = new Hashtable<String, String>();
        attributes.put(NAME, ADMIN_NAME);
        attributes.put(TYPE, SERVICE_TYPE);
        ObjectName objName = new ObjectName(PETALS_DOMAIN, attributes);
        Set<ObjectName> objNames = mBeanServer.queryNames(objName, null);
        if (objNames != null && objNames.size() == 1) {
            result = objNames.iterator().next();
        }
        return result;
    }

    public static ObjectName getComponentMBeanName(MBeanServerConnection mBeanServer, String name) throws IOException, MalformedObjectNameException, NullPointerException {
        ObjectName result = null;
        String pattern = "*:type=engine,name=" + name;
        ObjectName objName = new ObjectName(pattern);
        Set<ObjectName> objNames = mBeanServer.queryNames(objName, null);
        if (objNames != null && objNames.size() == 1) {
            result = objNames.iterator().next();
        }
        if (result == null && (objNames = mBeanServer.queryNames(objName = new ObjectName(pattern = "*:type=binding,name=" + name), null)) != null && objNames.size() == 1) {
            result = objNames.iterator().next();
        }
        return result;
    }

    public static JMXConnector getConnection(String host, String port, String username, String password) throws IOException {
        JMXConnector connector = null;
        Properties env = System.getProperties();
        env.put("java.naming.factory.initial", "com.sun.jndi.rmi.registry.RegistryContextFactory");
        HashMap<String, String[]> args = new HashMap<String, String[]>();
        if (!"".equals(username)) {
            if (password == null) {
                password = "";
            }
            String[] credentials = new String[]{username, password};
            args.put("jmx.remote.credentials", credentials);
        }
        String urlStr = "service:jmx:rmi:///jndi/rmi://" + host + ":" + port + "/management/rmi-jmx-connector";
        JMXServiceURL url = new JMXServiceURL(urlStr);
        connector = JMXConnectorFactory.connect(url, args);
        return connector;
    }

    public static ObjectName getDeploymentServiceMBeanName(MBeanServerConnection mBeanServer) throws IOException, MalformedObjectNameException, NullPointerException {
        ObjectName result = null;
        Hashtable<String, String> attributes = new Hashtable<String, String>();
        attributes.put(NAME, DEPLOYMENT_NAME);
        attributes.put(TYPE, SERVICE_TYPE);
        ObjectName objName = new ObjectName(PETALS_DOMAIN, attributes);
        Set<ObjectName> objNames = mBeanServer.queryNames(objName, null);
        if (objNames != null && objNames.size() == 1) {
            result = objNames.iterator().next();
        }
        return result;
    }

    public static ObjectName getInstallationServiceMBeanName(MBeanServerConnection mBeanServer) throws IOException, MalformedObjectNameException, NullPointerException {
        ObjectName result = null;
        Hashtable<String, String> attributes = new Hashtable<String, String>();
        attributes.put(NAME, INSTALLATION_NAME);
        attributes.put(TYPE, SERVICE_TYPE);
        ObjectName objName = new ObjectName(PETALS_DOMAIN, attributes);
        Set<ObjectName> objNames = mBeanServer.queryNames(objName, null);
        if (objNames != null && objNames.size() == 1) {
            result = objNames.iterator().next();
        }
        return result;
    }
}

