/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.components.protocol.lib.external_process;

import java.io.IOException;
import java.io.OutputStream;
import org.objectweb.fdf.components.protocol.lib.common.AbstractUsingDetectorProtocol;
import org.objectweb.fdf.util.io.Helper;
import org.objectweb.fdf.util.printer.api.Printer;

public class ExternalProcessProtocol
extends AbstractUsingDetectorProtocol {
    protected String commandToLaunch;
    private Process process;
    private Thread threadRedirectProcessInputStream;
    private Thread threadRedirectProcessErrorStream;
    private Printer printer2process;

    protected void init() {
        try {
            this.info("launch " + this.commandToLaunch);
            this.process = Runtime.getRuntime().exec(this.commandToLaunch);
        }
        catch (IOException ioe) {
            this.error(new Error("init", ioe));
            return;
        }
        this.threadRedirectProcessInputStream = Helper.newThreadInputStream2Printer(this.process.getInputStream(), this.output);
        this.threadRedirectProcessInputStream.start();
        this.threadRedirectProcessErrorStream = Helper.newThreadInputStream2Printer(this.process.getErrorStream(), this.logger);
        this.threadRedirectProcessErrorStream.start();
        this.printer2process = Helper.newPrinter(this.process.getOutputStream());
    }

    protected synchronized void initProtocol() {
        if (this.process != null) {
            return;
        }
        this.init();
        if (this.detector != null) {
            this.detector.send(null);
        }
    }

    public ExternalProcessProtocol() {
    }

    public ExternalProcessProtocol(Printer logger, Printer output, String commandToLaunch) {
        super(logger, output, null);
        this.commandToLaunch = commandToLaunch;
        this.init();
    }

    protected String getWhoIAm() {
        return "ExternalProcessProtocol(" + this.commandToLaunch + ')';
    }

    public void send(String command) {
        this.initProtocol();
        this.info("send - " + command);
        this.printer2process.print(command);
    }

    public OutputStream getOutputStream() {
        return this.process.getOutputStream();
    }

    public Printer getPrinter() {
        return this.printer2process;
    }

    public void waitFor() {
        try {
            this.process.waitFor();
        }
        catch (InterruptedException ie) {
            this.error(new Error("Could not wait for the end of the external process", ie));
        }
    }
}

