/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.components.protocol.lib.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import org.objectweb.fdf.components.internet.lib.JSchSoftware;
import org.objectweb.fdf.components.protocol.lib.common.AbstractInternetProtocol;
import org.objectweb.fdf.util.io.Helper;
import org.objectweb.fdf.util.printer.api.Printer;

public class JSchSSH
extends AbstractInternetProtocol {
    private JSchSoftware ssh;
    private Thread threadRedirectChannelInputStream;
    private JSchThreadWriter t;

    protected void initProtocol() {
        this.ssh = new JSchSoftware(this, "shell");
        Channel channel = this.ssh.getChannel();
        try {
            channel.setInputStream(null);
            channel.setOutputStream(null);
            this.threadRedirectChannelInputStream = Helper.newThreadInputStream2Printer(channel.getInputStream(), this.output);
            this.threadRedirectChannelInputStream.start();
            channel.connect();
            this.t = new JSchThreadWriter(Helper.newPrinter(channel.getOutputStream()));
            this.t.start();
        }
        catch (JSchException e) {
            throw new Error("initProtocol - Failed to initialize JSchSSHImpl", e);
        }
        catch (IOException e) {
            throw new Error("initProtocol - Failed to get stream from JSch", e);
        }
        this.setRemotePrinter(this.t);
    }

    public class JSchThreadWriter
    extends Thread
    implements Printer {
        private Printer printer;
        private Object cmd;

        public JSchThreadWriter(Printer printer) {
            this.printer = printer;
        }

        public synchronized void print(Object command) {
            this.cmd = command;
            this.notify();
            while (this.cmd != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    JSchThreadWriter jSchThreadWriter = this;
                    synchronized (jSchThreadWriter) {
                        while (this.cmd == null) {
                            this.wait();
                        }
                    }
                    this.printer.print(this.cmd);
                    jSchThreadWriter = this;
                    synchronized (jSchThreadWriter) {
                        this.cmd = null;
                        this.notify();
                    }
                }
            }
            catch (InterruptedException ie) {
                return;
            }
        }
    }
}

