/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.components.software.explorer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.tree.MutableTreeNode;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.DefaultCellViewFactory;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.objectweb.fdf.components.software.explorer.JGraphCellData;
import org.objectweb.fdf.components.software.explorer.JGraphMouseListener;
import org.objectweb.fdf.util.fractal.FractalHelper;
import org.objectweb.fractal.api.Interface;
import org.objectweb.util.explorer.api.Panel;
import org.objectweb.util.explorer.api.TreeView;
import org.objectweb.util.explorer.swing.lib.DynamicTree;

public class JGraphPanel
extends JPanel
implements Panel {
    private static final long serialVersionUID = -7322518151844686455L;
    protected static Map jgraphes = new HashMap();
    protected JGraph jgraph;
    protected Map cells;
    protected int[] lastX;

    protected DefaultGraphCell getGraphCell(org.objectweb.fractal.api.Component component) {
        return (DefaultGraphCell)this.cells.get(component);
    }

    protected void placeComponent(org.objectweb.fractal.api.Component component, int depth) {
        JGraphCellData cellData = new JGraphCellData(component);
        DefaultGraphCell cell = new DefaultGraphCell((Object)cellData);
        AttributeMap cellAttributes = cell.getAttributes();
        cell.add((MutableTreeNode)new DefaultPort());
        Icon icon = cellData.getIcon();
        if (icon != null) {
            GraphConstants.setIcon((Map)cellAttributes, (Icon)icon);
        }
        GraphConstants.setBounds((Map)cellAttributes, (Rectangle2D)new Rectangle2D.Double(this.lastX[depth] * 128 + 16, depth * 80 + 16, 0.0, 0.0));
        int n = depth;
        this.lastX[n] = this.lastX[n] + 1;
        GraphConstants.setAutoSize((Map)cellAttributes, (boolean)true);
        GraphConstants.setResize((Map)cellAttributes, (boolean)false);
        GraphConstants.setEditable((Map)cellAttributes, (boolean)false);
        this.jgraph.getGraphLayoutCache().insert((Object)cell);
        this.cells.put(component, cell);
    }

    protected void connectComponents(org.objectweb.fractal.api.Component source, org.objectweb.fractal.api.Component target, Object edgeData) {
        DefaultEdge edge = new DefaultEdge(edgeData);
        edge.setSource((Object)this.getGraphCell(source).getChildAt(0));
        edge.setTarget((Object)this.getGraphCell(target).getChildAt(0));
        AttributeMap edgeAttributes = edge.getAttributes();
        GraphConstants.setLineEnd((Map)edgeAttributes, (int)1);
        GraphConstants.setEndFill((Map)edgeAttributes, (boolean)true);
        GraphConstants.setEditable((Map)edgeAttributes, (boolean)false);
        GraphConstants.setMoveable((Map)edgeAttributes, (boolean)false);
        GraphConstants.setDisconnectable((Map)edgeAttributes, (boolean)false);
        GraphConstants.setSizeable((Map)edgeAttributes, (boolean)false);
        GraphConstants.setBendable((Map)edgeAttributes, (boolean)false);
        this.jgraph.getGraphLayoutCache().insert((Object)edge);
    }

    protected org.objectweb.fractal.api.Component getHostComponent(org.objectweb.fractal.api.Component component) {
        org.objectweb.fractal.api.Component host = FractalHelper.getSubComponentByName(component, "host");
        if (host != null) {
            return host;
        }
        org.objectweb.fractal.api.Component[] sc = FractalHelper.getSuperComponents(component);
        org.objectweb.fractal.api.Component software = FractalHelper.getComponentByName(sc, "software");
        if (software != null) {
            return FractalHelper.getLastSuperComponent(software);
        }
        software = FractalHelper.getComponentByName(sc, FractalHelper.getComponentName(component));
        if (software != null) {
            return this.getHostComponent(software);
        }
        return FractalHelper.getSubComponentByName(sc[sc.length - 1], "host");
    }

    protected void visit(org.objectweb.fractal.api.Component component, int depth) {
        org.objectweb.fractal.api.Component host;
        if (this.getGraphCell(component) != null) {
            return;
        }
        this.placeComponent(component, depth);
        org.objectweb.fractal.api.Component dependenciesComponent = FractalHelper.getSubComponentByName(component, "dependencies");
        if (dependenciesComponent == null) {
            org.objectweb.fractal.api.Component internalDeployment = FractalHelper.getSubComponentByName(component, "internal-deployment");
            if (internalDeployment == null) {
                org.objectweb.fractal.api.Component[] subSoftware = FractalHelper.getSubComponents(component);
                for (int i = 0; i < subSoftware.length; ++i) {
                    String componentName = FractalHelper.getComponentName(subSoftware[i]);
                    Object deploymentItf = FractalHelper.getInterface(FractalHelper.getComponentByName(subSoftware, componentName), "deployment");
                    if (deploymentItf == null || !FractalHelper.isPublicName(FractalHelper.getComponentName(subSoftware[i]))) continue;
                    this.visit(subSoftware[i], depth + 1);
                    this.connectComponents(component, subSoftware[i], "depend");
                }
                return;
            }
            dependenciesComponent = FractalHelper.getSubComponentByName(internalDeployment, "dependencies");
        }
        if (dependenciesComponent != null) {
            org.objectweb.fractal.api.Component[] dependencies = FractalHelper.getSubComponents(dependenciesComponent);
            for (int j = 0; j < dependencies.length; ++j) {
                org.objectweb.fractal.api.Component d = dependencies[j];
                String dn = FractalHelper.getComponentName(d);
                if (!FractalHelper.isPublicName(dn)) continue;
                if (dn.equals("start-when-install")) {
                    org.objectweb.fractal.api.Component[] swi = FractalHelper.getSubComponents(d);
                    for (int k = 0; k < swi.length; ++k) {
                        if (!FractalHelper.isPublicName(FractalHelper.getComponentName(swi[k]))) continue;
                        this.visit(swi[k], depth + 1);
                        this.connectComponents(component, swi[k], "depend");
                    }
                    continue;
                }
                this.visit(d, depth + 1);
                this.connectComponents(component, d, "depend");
            }
        }
        if ((host = this.getHostComponent(component)) != null) {
            if (this.getGraphCell(host) == null) {
                this.placeComponent(host, depth + 1);
            }
            this.connectComponents(component, host, "host");
        }
    }

    protected void visit(org.objectweb.fractal.api.Component component) {
        this.visit(component, 0);
    }

    public JGraphPanel() {
        super(new BorderLayout());
        this.setBackground(Color.white);
    }

    public void selected(TreeView treeView) {
        org.objectweb.fractal.api.Component component = ((Interface)treeView.getSelectedObject()).getFcItfOwner();
        this.jgraph = (JGraph)jgraphes.get(component);
        if (this.jgraph == null) {
            DefaultGraphModel model = new DefaultGraphModel();
            GraphLayoutCache view = new GraphLayoutCache((GraphModel)model, (CellViewFactory)new DefaultCellViewFactory());
            this.jgraph = new JGraph((GraphModel)model, view);
            this.jgraph.addMouseListener((MouseListener)new JGraphMouseListener(this.jgraph, (DynamicTree)treeView.getTree()));
            this.lastX = new int[256];
            this.cells = new HashMap();
            this.visit(component);
            jgraphes.put(component, this.jgraph);
        }
        this.add((Component)this.jgraph, "Center");
    }

    public Object getPanel() {
        return this;
    }

    public void unselected(TreeView treeView) {
    }
}

