/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.components.transfer.lib.ftp;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.objectweb.fdf.components.transfer.lib.common.AbstractInternetTransfer;

public class Apache_Commons_Net_FTP_Transfer
extends AbstractInternetTransfer {
    private FTPClient initFTPConnection() {
        FTPClient ftp = new FTPClient();
        String hostname = this.hostname.getHostname();
        this.info("Apache_Commons_Net_FTP_Transfer - connecting to " + hostname);
        try {
            ftp.connect(hostname);
        }
        catch (IOException exception) {
            throw new Error("initFTPConnection - Could not connect to the FTP server", exception);
        }
        int reply = ftp.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            this.warning("Apache_Commons_Net_FTP_Transfer - connection refused - " + ftp.getReplyString());
            try {
                ftp.disconnect();
            }
            catch (IOException exception) {
                throw new Error("initFTPConnection - Could not disconnect from the FTP server", exception);
            }
            return null;
        }
        this.info("Apache_Commons_Net_FTP_Transfer - logging as " + this.user.getLogin());
        boolean logged = false;
        try {
            logged = ftp.login(this.user.getLogin(), this.user.getPassword());
        }
        catch (IOException exception) {
            throw new Error("initFTPConnection - Could not login to the FTP server", exception);
        }
        if (!logged) {
            this.warning("Apache_Commons_Net_FTP_Transfer - login refused - " + ftp.getReplyString());
            this.closeFTPConnection(ftp);
            return null;
        }
        try {
            ftp.setFileType(2);
        }
        catch (IOException exception) {
            throw new Error("Could not set binary file type", exception);
        }
        ftp.enterLocalPassiveMode();
        return ftp;
    }

    private void closeFTPConnection(FTPClient ftp) {
        try {
            ftp.logout();
        }
        catch (IOException exception) {
            throw new Error("Could not logout from the FTP server", exception);
        }
        try {
            ftp.disconnect();
        }
        catch (IOException exception) {
            throw new Error("Could not disconnect from the FTP server", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalDownload(String source, String destination) {
        block14: {
            FileOutputStream output = null;
            try {
                output = new FileOutputStream(destination);
            }
            catch (FileNotFoundException exception) {
                throw new Error("download - Could not create the file " + destination, exception);
            }
            try {
                FTPClient ftp = this.initFTPConnection();
                if (ftp == null) break block14;
                this.info("download " + source + " to " + destination);
                try {
                    ftp.retrieveFile(source, (OutputStream)output);
                }
                catch (IOException exception) {
                    throw new Error("download - Could not download the source file", exception);
                }
                finally {
                    this.closeFTPConnection(ftp);
                }
            }
            finally {
                try {
                    ((OutputStream)output).close();
                }
                catch (IOException exception) {
                    throw new Error("Could not close the destination file", exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalUpload(String source, String destination) {
        block14: {
            FileInputStream input = null;
            try {
                input = new FileInputStream(source);
            }
            catch (IOException exception) {
                throw new Error("upload - Could not open the source file", exception);
            }
            try {
                FTPClient ftp = this.initFTPConnection();
                if (ftp == null) break block14;
                this.info("upload " + source + " to " + destination);
                try {
                    ftp.storeFile(destination, (InputStream)input);
                }
                catch (IOException exception) {
                    throw new Error("upload - Could not upload the file", exception);
                }
                finally {
                    this.closeFTPConnection(ftp);
                }
            }
            finally {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException exception) {
                    throw new Error("upload - Could not close the source file", exception);
                }
            }
        }
    }
}

