/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.components.transfer.lib.scp;

import com.jcraft.jsch.ChannelExec;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.objectweb.fdf.components.internet.lib.JSchSoftware;
import org.objectweb.fdf.components.transfer.lib.common.AbstractInternetTransfer;

public class JSchScpImpl
extends AbstractInternetTransfer {
    private JSchSoftware newScp(String command) {
        JSchSoftware scp = new JSchSoftware(this, "exec");
        ((ChannelExec)scp.getChannel()).setCommand(command);
        return scp;
    }

    private static int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                System.out.print(sb.toString());
            }
            if (b == 2) {
                System.out.print(sb.toString());
            }
        }
        return b;
    }

    private static void sendAck(OutputStream out) throws IOException {
        out.write(0);
        out.flush();
    }

    public void internalDownload(String source, String destination) {
        JSchSoftware scp = this.newScp("scp -f " + source);
        FileOutputStream fos = null;
        try {
            int c;
            String prefix = null;
            if (new File(source).isDirectory()) {
                prefix = source + File.separator;
            }
            ChannelExec channel = (ChannelExec)scp.getChannel();
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            JSchScpImpl.sendAck(out);
            byte[] buf = new byte[1024];
            while ((c = JSchScpImpl.checkAck(in)) == 67) {
                int foo;
                in.read(buf, 0, 5);
                long filesize = 0L;
                while (in.read(buf, 0, 1) >= 0 && buf[0] != 32) {
                    filesize = filesize * 10L + (long)(buf[0] - 48);
                }
                String file = null;
                int i = 0;
                while (true) {
                    in.read(buf, i, 1);
                    if (buf[i] == 10) break;
                    ++i;
                }
                file = new String(buf, 0, i);
                JSchScpImpl.sendAck(out);
                fos = new FileOutputStream(prefix == null ? destination : prefix + file);
                do {
                    foo = (long)buf.length < filesize ? buf.length : (int)filesize;
                    if ((foo = in.read(buf, 0, foo)) < 0) break;
                    fos.write(buf, 0, foo);
                } while ((filesize -= (long)foo) != 0L);
                fos.close();
                fos = null;
                if (JSchScpImpl.checkAck(in) != 0) {
                    throw new Error("download - Failed to download file");
                }
                JSchScpImpl.sendAck(out);
            }
        }
        catch (Exception e) {
            throw new Error("download - Failed to download " + source + " to " + destination, e);
        }
        finally {
            scp.disconnect();
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception ee) {
                throw new Error("download - Failed to close the OutputStream of " + destination, ee);
            }
        }
    }

    public void internalUpload(String source, String destination) {
        JSchSoftware scp = this.newScp("scp -p -t " + destination);
        FileInputStream fis = null;
        try {
            int len;
            ChannelExec channel = (ChannelExec)scp.getChannel();
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            if (JSchScpImpl.checkAck(in) != 0) {
                throw new Error("upload - Failed to connect to JSch channel");
            }
            long filesize = new File(source).length();
            StringBuffer command = new StringBuffer();
            command.append("C0644 ");
            command.append(filesize);
            command.append(' ');
            if (source.lastIndexOf(47) > 0) {
                command.append(source.substring(source.lastIndexOf(47) + 1));
            } else {
                command.append(source);
            }
            command.append('\n');
            out.write(command.toString().getBytes());
            out.flush();
            if (JSchScpImpl.checkAck(in) != 0) {
                throw new Error("upload - Failed to send command on JSch channel");
            }
            fis = new FileInputStream(source);
            byte[] buf = new byte[16384];
            while ((len = fis.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, len);
            }
            fis.close();
            fis = null;
            JSchScpImpl.sendAck(out);
            if (JSchScpImpl.checkAck(in) != 0) {
                throw new Error("upload - Failed to upload file");
            }
            out.close();
        }
        catch (Exception e) {
            throw new Error("upload - Failed to upload file", e);
        }
        finally {
            scp.disconnect();
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception ee) {
                throw new Error("upload - Failed to close the InputStream of " + source, ee);
            }
        }
    }
}

