/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.parser.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import org.objectweb.fdf.parser.api.Parser;
import org.objectweb.fdf.parser.api.PreprocessedClassLoader;
import org.objectweb.fdf.parser.common.FDFParser;
import org.objectweb.fdf.parser.common.ParseException;

public class FDFClassLoader
extends URLClassLoader
implements PreprocessedClassLoader {
    protected Parser parser = new FDFParser();
    protected String extension = "fdf";

    public FDFClassLoader() {
        super(new URL[0]);
    }

    public FDFClassLoader(URL[] urls) {
        super(urls);
    }

    public FDFClassLoader(ClassLoader classLoader) {
        super(new URL[0], classLoader);
    }

    public FDFClassLoader(URL[] urls, ClassLoader classLoader) {
        super(urls, classLoader);
    }

    public InputStream getResourceAsStream(String name) {
        String extFile;
        InputStream input = super.getResourceAsStream(name);
        if (input != null) {
            return input;
        }
        String fileExtension = name.substring(name.lastIndexOf("."));
        if (fileExtension.equals(".fractal") && (input = super.getResourceAsStream(extFile = name.substring(0, name.lastIndexOf(".fractal")) + "." + this.extension)) != null) {
            try {
                InputStream result = this.parse(input);
                if (System.getProperties().containsKey("DEBUG")) {
                    int c;
                    result.mark(1024);
                    FileWriter fw = new FileWriter(new File(name.replaceAll(File.separator, ".")));
                    while ((c = result.read()) != -1) {
                        fw.write(c);
                    }
                    fw.close();
                    result.reset();
                }
                return result;
            }
            catch (ParseException e) {
                throw new Error("Error in " + extFile + ": " + e.getMessage(), e);
            }
            catch (IOException e2) {
                throw new Error("IOException when writing " + name + ": " + e2.getMessage());
            }
        }
        return null;
    }

    protected InputStream parse(InputStream in) throws ParseException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.parser.transform(in, out);
        try {
            in.close();
            out.close();
        }
        catch (IOException ioe) {
            throw new Error("Can't close stream: " + ioe.getMessage());
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    public String getDefinition(InputStream in) throws ParseException {
        return this.parser.getDefinition(in);
    }

    public String getExtension() {
        return this.extension;
    }
}

