/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf.util.fractal;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.api.control.NameController;
import org.objectweb.fractal.api.control.SuperController;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.Util;
import org.objectweb.fractal.util.Fractal;

public class FractalHelper {
    protected FractalHelper() {
    }

    public static boolean isPublicName(String name) {
        return !name.startsWith("internal-");
    }

    public static boolean isControllerInterface(Interface itf) {
        String itfName = itf.getFcItfName();
        return itfName.endsWith("-controller") || itfName.equals("factory") || itfName.equals("component");
    }

    public static boolean isServerInterface(Interface itf) {
        return !((InterfaceType)itf.getFcItfType()).isFcClientItf() && !FractalHelper.isControllerInterface(itf);
    }

    public static boolean isPublicInterface(Interface itf) {
        return FractalHelper.isServerInterface(itf) && FractalHelper.isPublicName(itf.getFcItfName());
    }

    public static Object getInterface(Component component, String name) {
        try {
            return component.getFcInterface(name);
        }
        catch (NoSuchInterfaceException e) {
            return null;
        }
    }

    public static String toString(Component component) {
        StringBuffer buffer = new StringBuffer();
        Util.toString((Component)component, (StringBuffer)buffer);
        String tmp = buffer.toString();
        return tmp.substring(tmp.indexOf(47, 1));
    }

    public static LifeCycleController getLifeCycleController(Component component) throws NoSuchInterfaceException {
        return Fractal.getLifeCycleController((Component)component);
    }

    public static String getComponentName(Object itf) {
        return FractalHelper.getComponentName(((Interface)itf).getFcItfOwner());
    }

    public static String getComponentName(Interface itf) {
        return FractalHelper.getComponentName(itf.getFcItfOwner());
    }

    public static String getComponentName(Component component) {
        try {
            NameController nc = Fractal.getNameController((Component)component);
            return nc.getFcName();
        }
        catch (NoSuchInterfaceException e) {
            return "unknown";
        }
    }

    public static Component getComponentByName(Component[] components, String name) {
        for (int i = 0; i < components.length; ++i) {
            Component c = components[i];
            if (!FractalHelper.getComponentName(c).equals(name)) continue;
            return c;
        }
        return null;
    }

    public static Component[] getSuperComponents(Component component) {
        try {
            SuperController sc = Fractal.getSuperController((Component)component);
            return sc.getFcSuperComponents();
        }
        catch (NoSuchInterfaceException e) {
            return new Component[0];
        }
    }

    public static Component getLastSuperComponent(Component component) {
        Component[] superComponents = FractalHelper.getSuperComponents(component);
        return superComponents[superComponents.length - 1];
    }

    public static Component[] getSubComponents(Component component) {
        try {
            ContentController cc = Fractal.getContentController((Component)component);
            return cc.getFcSubComponents();
        }
        catch (NoSuchInterfaceException e) {
            return new Component[0];
        }
    }

    public static Component getSubComponentByName(Component component, String name) {
        return FractalHelper.getComponentByName(FractalHelper.getSubComponents(component), name);
    }
}

