/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.loader;

public class Tree {
    private final String leaf;
    private final Tree[] subTrees;

    public Tree(String leaf) {
        this.leaf = leaf;
        this.subTrees = null;
    }

    public Tree(Tree[] subTrees) {
        this.leaf = null;
        this.subTrees = subTrees;
    }

    public int getSize() {
        return this.subTrees == null ? 0 : this.subTrees.length;
    }

    public Tree getSubTree(int index) {
        if (this.subTrees == null) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.subTrees[index];
    }

    public Tree[] getSubTrees() {
        if (this.subTrees == null) {
            return new Tree[0];
        }
        return this.subTrees;
    }

    public Tree getValue(String key) {
        Tree[] t = this.getSubTrees();
        int i = 0;
        while (i < t.length) {
            if (t[i].getSize() == 2 && t[i].getSubTree(0).equals(key)) {
                return t[i].getSubTree(1);
            }
            ++i;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof String) {
            String s = (String)o;
            return this.equals(s, 0, s.length()) == 0;
        }
        throw new RuntimeException("Not yet implemented");
    }

    public int hashCode() {
        return this.hashCode(0);
    }

    public String toString() {
        if (this.leaf != null) {
            return this.leaf;
        }
        if (this.subTrees.length == 0) {
            return "()";
        }
        StringBuffer buf = new StringBuffer();
        this.toString(buf);
        return buf.toString();
    }

    private int hashCode(int hc) {
        if (this.leaf != null) {
            hc = 17 * (hc + this.leaf.hashCode());
        } else {
            int l = this.subTrees.length;
            hc = 17 * (hc + 40);
            int i = 0;
            while (i < l) {
                if (i > 0) {
                    hc = 17 * (hc + 32);
                }
                hc = this.subTrees[i].hashCode(hc);
                ++i;
            }
            hc = 17 * (hc + 41);
        }
        return hc;
    }

    public int equals(String str, int off, int len) {
        if (this.leaf != null) {
            int l = this.leaf.length();
            if (len < l || !str.regionMatches(false, off, this.leaf, 0, l)) {
                return -1;
            }
            return len - l;
        }
        int l = this.subTrees.length;
        if (len == 0 || str.charAt(off) != '(') {
            return -1;
        }
        ++off;
        --len;
        int i = 0;
        while (i < l) {
            int newLen;
            if (i > 0) {
                if (len == 0 || str.charAt(off) != ' ') {
                    return -1;
                }
                ++off;
                --len;
            }
            if ((newLen = this.subTrees[i].equals(str, off, len)) == -1) {
                return -1;
            }
            off += len - newLen;
            len = newLen;
            ++i;
        }
        if (len == 0 || str.charAt(off) != ')') {
            return -1;
        }
        return len - 1;
    }

    private void toString(StringBuffer buf) {
        if (this.subTrees == null) {
            buf.append(this.leaf);
        } else {
            int l = this.subTrees.length;
            buf.append('(');
            int i = 0;
            while (i < l) {
                if (i > 0) {
                    buf.append(' ');
                }
                this.subTrees[i].toString(buf);
                ++i;
            }
            buf.append(')');
        }
    }
}

