/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JGroupsHandler.java 9171 2011-10-13 14:30:56Z richardd $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.agent.remote.discovery.application.jonas;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.View;
import org.ow2.jonas.discovery.base.comm.DiscEvent;
import org.ow2.jonas.discovery.jgroups.comm.api.DiscCommReceiver;
import org.ow2.jonas.discovery.jgroups.utils.Data;
import org.ow2.jonas.discovery.jgroups.utils.JGroupsDiscoveryUtils;

/**
 * Basic implementation of a DiscCommReceiver
 * 
 * @author Julien Vey
 */
public class JGroupsHandler implements DiscCommReceiver {

    /**
     * the list of urls received
     */
    private List<String> urlConnectors;

    /**
     * Default constructor
     */
    public JGroupsHandler() {
        urlConnectors = new ArrayList<String>();
    }

    /*
     * (non-Javadoc)
     * @see org.jgroups.MessageListener#getState()
     */
    public byte[] getState() {
        return null;
    }

    /*
     * (non-Javadoc)
     * @see org.jgroups.MessageListener#receive(org.jgroups.Message)
     */
    public void receive(Message msg) {
        Object objReceived = null;
        Data data = null;

        data = (Data) msg.getObject();
        try {
            objReceived = JGroupsDiscoveryUtils.bytesToObject(data);
        } catch (IOException e) {
            e.printStackTrace();
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (objReceived != null) {
            if (objReceived instanceof DiscEvent) {
                DiscEvent event = (DiscEvent) objReceived;
                for (int i = 0; i < event.getConnectorURL().length; i++) {
                    urlConnectors.add(event.getConnectorURL()[i]);
                }
            }
        }

    }

    /*
     * (non-Javadoc)
     * @see org.jgroups.MessageListener#setState(byte[])
     */
    public void setState(byte[] arg0) {
    }

    /*
     * (non-Javadoc)
     * @see org.jgroups.MembershipListener#block()
     */
    public void block() {
    }

    /*
     * (non-Javadoc)
     * @see org.jgroups.MembershipListener#suspect(org.jgroups.Address)
     */
    public void suspect(Address arg0) {
    }

    /*
     * (non-Javadoc)
     * @see org.jgroups.MembershipListener#viewAccepted(org.jgroups.View)
     */
    public void viewAccepted(View arg0) {
    }

    /*
     * (non-Javadoc)
     * @see org.jgroups.ExtendedMessageListener#getState(java.lang.String)
     */
    public byte[] getState(String arg0) {
        return null;
    }

    /*
     * (non-Javadoc)
     * @see org.jgroups.ExtendedMessageListener#getState(java.io.OutputStream)
     */
    public void getState(OutputStream arg0) {
    }

    /*
     * (non-Javadoc)
     * @see org.jgroups.ExtendedMessageListener#getState(java.lang.String, java.io.OutputStream)
     */
    public void getState(String arg0, OutputStream arg1) {
    }

    /*
     * (non-Javadoc)
     * @see org.jgroups.ExtendedMessageListener#setState(java.io.InputStream)
     */
    public void setState(InputStream arg0) {
    }

    /*
     * (non-Javadoc)
     * @see org.jgroups.ExtendedMessageListener#setState(java.lang.String, byte[])
     */
    public void setState(String arg0, byte[] arg1) {
    }

    /*
     * (non-Javadoc)
     * @see org.jgroups.ExtendedMessageListener#setState(java.lang.String, java.io.InputStream)
     */
    public void setState(String arg0, InputStream arg1) {
    }

    /*
     * (non-Javadoc)
     * @see org.jgroups.ExtendedMembershipListener#unblock()
     */
    public void unblock() {
    }

    /**
     * @return the urlConnectors
     */
    public List<String> getUrlConnectors() {
        return urlConnectors;
    }

    /**
     * @param urlConnectors
     *            the urlConnectors to set
     */
    public void setUrlConnectors(List<String> urlConnectors) {
        this.urlConnectors = urlConnectors;
    }

}
