/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: PostgreSQLApplicationPropertiesMap.java 9171 2011-10-13 14:30:56Z richardd $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.agent.remote.discovery.application.postgresql;

import java.util.ArrayList;
import java.util.List;

import org.ow2.jasmine.agent.common.discovery.ApplicationProperty;

/**
 * Properties Map for PostgreSQL application
 * 
 * @author Julien Vey
 */
public class PostgreSQLApplicationPropertiesMap {

    /**
     * listen addresse key
     */
    public static final String LISTEN_KEY = "Listening addresses";

    /**
     * port key
     */
    public static final String PORT_KEY = "Listening port";

    /**
     * Max connections key
     */
    public static final String MAX_KEY = "Maximum Connections";

    /**
     * port
     */
    private int port;

    /**
     * listening addresses
     */
    private String listeningAddresses;

    /**
     * maximum connections
     */
    private int maxConnections;

    /**
     * Default constructor with no parameters
     */
    public PostgreSQLApplicationPropertiesMap() {
    }

    /**
     * Constructor which set fields using map properties
     * 
     * @param map
     *            the map containing the properties
     */
    public PostgreSQLApplicationPropertiesMap(List<ApplicationProperty> list) {
        setListeningAddresses(getPropFromList(LISTEN_KEY, list));
        setMaxConnections(setValue(getPropFromList(MAX_KEY, list)));
        setPort(setValue(getPropFromList(PORT_KEY, list)));
    }

    /**
     * Utility method to convert a String in an int
     * 
     * @param val
     * @return
     */
    public int setValue(String val) {
        if (val == null) {
            return 0;
        } else {
            return Integer.parseInt(val);
        }
    }

    /**
     * Get a property from the list of properties
     * 
     * @param key
     *            the key of the property
     * @param props
     *            the list of properties
     * @return the property value found
     */
    private String getPropFromList(String key, List<ApplicationProperty> props) {
        for (ApplicationProperty prop : props) {
            if (prop.getPropertyName().equals(key)) {
                return prop.getPropertyValue();
            }
        }
        return null;
    }

    /**
     * get the field of the class as a map
     * 
     * @return the map of properties
     */
    public List<ApplicationProperty> getPropertiesList() {
        List<ApplicationProperty> list = new ArrayList<ApplicationProperty>();
        list.add(new ApplicationProperty(LISTEN_KEY, listeningAddresses));
        list.add(new ApplicationProperty(PORT_KEY, getValue(port)));
        list.add(new ApplicationProperty(MAX_KEY, getValue(maxConnections)));

        return list;
    }

    public String getValue(int val) {
        if (String.valueOf(val).equals("0")) {
            return null;
        } else {
            return String.valueOf(val);
        }
    }

    /**
     * @return the port
     */
    public int getPort() {
        return port;
    }

    /**
     * @param port
     *            the port to set
     */
    public void setPort(int port) {
        this.port = port;
    }

    /**
     * @return the listeningAddresses
     */
    public String getListeningAddresses() {
        return listeningAddresses;
    }

    /**
     * @param listeningAddresses
     *            the listeningAddresses to set
     */
    public void setListeningAddresses(String listeningAddresses) {
        this.listeningAddresses = listeningAddresses;
    }

    /**
     * @return the maxConnections
     */
    public int getMaxConnections() {
        return maxConnections;
    }

    /**
     * @param maxConnections
     *            the maxConnections to set
     */
    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }
}
