/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DiscoveryServiceRunner.java 9171 2011-10-13 14:30:56Z richardd $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.agent.server.discovery;

import java.util.List;

import org.ow2.jasmine.agent.common.discovery.Application;
import org.ow2.jasmine.agent.common.discovery.ApplicationDiscoveryService;
import org.ow2.jasmine.agent.server.Agent;

/**
 * A runner is a thread that will discovery applications on an agent
 * 
 * @author Julien Vey
 */
public class DiscoveryServiceRunner extends Thread {

    /**
     * discovery services
     */
    private List<ApplicationDiscoveryService> discoveryServices;

    /**
     * The agent who call this Runner
     */
    private Agent parentAgent;

    /**
     * Default constructor
     * 
     * @param services
     * @param agent
     */
    public DiscoveryServiceRunner(List<ApplicationDiscoveryService> services, Agent agent) {
        this.discoveryServices = services;
        this.parentAgent = agent;
    }

    /*
     * (non-Javadoc)
     * @see java.lang.Thread#run()
     */
    public void run() {
        System.out.println("Discovery Service size : " + discoveryServices.size());
        for (ApplicationDiscoveryService service : discoveryServices) {
            List<Application> applicationDiscovered = service.discoverApplications();
            parentAgent.addDiscoveredApplication(applicationDiscovered);
        }
        parentAgent.endDiscovery();

    }

}
