/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: CustomFileFilter.java 9171 2011-10-13 14:30:56Z richardd $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.agent.utils.filesystem.discovery.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;

import org.ow2.jasmine.agent.utils.pattern.Child;
import org.ow2.jasmine.agent.utils.pattern.ChildType;

/**
 * A Customized FileFilter designed to filter files according to a given Child
 * 
 * @author Julien Vey
 */
public class CustomFileFilter implements FileFilter {

    /**
     * the name of the file to be accepted
     */
    String name;

    /**
     * The type of the file to be accepted
     */
    ChildType type;

    /**
     * Constructor with a name and a type
     * 
     * @param name
     *            the name of the files to filter
     * @param type
     *            the type of the files to filter
     */
    public CustomFileFilter(String name, ChildType type) {
        this.name = name;
        this.type = type;
    }

    /**
     * Constructor with a child
     * 
     * @param c
     *            the child to filter
     */
    public CustomFileFilter(Child c) {
        this.name = c.getName();
        this.type = c.getType();
    }

    /*
     * (non-Javadoc)
     * @see java.io.FileFilter#accept(java.io.File)
     */
    public boolean accept(File file) {
        try {
            Boolean b1 = ((file.isDirectory() && this.type.equals(ChildType.DIRECTORY)) || (file.isFile() && this.type
                    .equals(ChildType.FILE)));
            Boolean b2 = this.name.equals(file.getName());
            Boolean b3 = file.getAbsolutePath().equals(file.getCanonicalPath());

            boolean res = b1 && b2 && b3;
            return res;
        } catch (IOException e) {
            return false;
        }
    }
}
