/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: UtilTest.java 9171 2011-10-13 14:30:56Z richardd $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.agent.utils.pattern.test;

import java.util.LinkedList;
import java.util.List;

import org.ow2.jasmine.agent.utils.pattern.Child;
import org.ow2.jasmine.agent.utils.pattern.ChildType;
import org.ow2.jasmine.agent.utils.pattern.DiscoveryPattern;
import org.ow2.jasmine.agent.utils.pattern.PatternUtility;
import org.testng.Assert;
import org.testng.annotations.Test;

/**
 * Class to test Utility methods
 * 
 * @author Julien Vey
 */
public class UtilTest {

    /**
     * Test the file to pattern conversion
     */
    @Test
    public void PatternConversionTest() {

        DiscoveryPattern convertedPattern = PatternUtility.convertFileToPattern(this.getClass().getResourceAsStream(
                "/testPattern.xml"));

        Child dirTest1 = new Child("dirtest1", ChildType.DIRECTORY);
        Child dirTest2 = new Child("dirtest2", ChildType.DIRECTORY);
        Child dirTest3 = new Child("dirtest3", ChildType.DIRECTORY);
        Child dirTest4 = new Child("dirtest4", ChildType.DIRECTORY);
        Child fileTest1 = new Child("filetest1", ChildType.FILE);

        Child subFileTest1 = new Child("subfiletest1", ChildType.FILE);
        Child subFileTest2 = new Child("subfiletest2", ChildType.FILE);
        Child subDirTest1 = new Child("subdirtest1", ChildType.DIRECTORY);
        Child subDirTest2 = new Child("subdirtest2", ChildType.DIRECTORY);

        Child subSubFileTest1 = new Child("subsubfiletest1", ChildType.FILE);
        Child subSubDirTest1 = new Child("subsubdirtest1", ChildType.DIRECTORY);

        subDirTest1.addChild(subSubFileTest1);
        subDirTest1.addChild(subSubDirTest1);

        dirTest3.addChild(subFileTest1);
        dirTest3.addChild(subDirTest1);
        dirTest3.addChild(subDirTest2);

        dirTest4.addChild(subFileTest2);

        List<Child> mainChildList = new LinkedList<Child>();

        mainChildList.add(dirTest1);
        mainChildList.add(dirTest2);
        mainChildList.add(fileTest1);
        mainChildList.add(dirTest3);
        mainChildList.add(dirTest4);

        DiscoveryPattern createdPattern = new DiscoveryPattern(mainChildList);

        Assert.assertTrue(compareListsByContent(createdPattern.getChildList(), convertedPattern.getChildList()));

    }

    /**
     * Compare two lists of Child by their content
     * 
     * @param l1
     *            the first list to compare
     * @param l2
     *            the second list to compare
     * @return true if the two lists are equals, false if they are not
     */
    public boolean compareListsByContent(List<Child> l1, List<Child> l2) {
        boolean bEqual = l1.size() == l2.size();

        if (bEqual) {
            for (int i = 0; i < l1.size(); i++) {
                if (bEqual) {
                    Child c1 = l1.get(i);
                    Child c2 = l2.get(i);
                    bEqual = (compareChildren(c1, c2) && compareListsByContent(c1.getChildren(), c2.getChildren()));
                }
            }
        }

        return bEqual;
    }

    /**
     * Compare two Children
     * 
     * @param c1 the first child to compare
     * @param c2 the second child to compare
     * @return true if c1 equals c2 by name and type
     */
    private boolean compareChildren(Child c1, Child c2) {
        return (c1.getName().equals(c2.getName()) && c1.getType().equals(c2.getType()));
    }

}
