/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.deployme.api;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.ow2.jasmine.deployme.api.DeployMEPropertiesManager;
import org.ow2.jasmine.deployme.generated.Topology;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlLoader {
    Topology topology;

    public XmlLoader(URL topologyUrl) throws SAXException, JAXBException, IOException {
        this.topology = XmlLoader.loadSchemaAndFile(DeployMEPropertiesManager.getXsdTopologyPath(), DeployMEPropertiesManager.getTopologyXMLNS(), DeployMEPropertiesManager.getTopologySchemaLocation(), "topology", Topology.class, topologyUrl);
    }

    public static <T> T loadSchemaAndFile(String xsdPath, String xmlns, String schemaLocation, String xmlRoot, Class<T> rootClass, URL urlXML) throws SAXException, JAXBException, IOException {
        int xmlnsIndex;
        int xmlRootEnd;
        JAXBContext jc = JAXBContext.newInstance((String)rootClass.getPackage().getName());
        Unmarshaller unMarshaller = jc.createUnmarshaller();
        URL xsdURL = rootClass.getClassLoader().getResource(xsdPath);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(xsdURL);
        unMarshaller.setSchema(schema);
        String xml = XmlLoader.readURL(urlXML);
        int xmlRootStart = xml.indexOf("<" + xmlRoot);
        if (xmlRootStart != -1 && (xmlRootEnd = xml.indexOf(">", xmlRootStart)) != -1 && (xmlnsIndex = xml.indexOf("xmlns", xmlRootStart)) == -1) {
            xml = xml.substring(0, xmlRootStart) + "<" + xmlRoot + " xmlns=\"" + xmlns + "\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"" + xmlns + " " + schemaLocation + "\"" + xml.substring(xmlRootStart + xmlRoot.length() + 1);
        }
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xml.getBytes());
        return (T)unMarshaller.unmarshal((InputStream)xmlInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readURL(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        try {
            String inputLine;
            StringBuilder sb = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(inputLine);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            in.close();
        }
    }

    public Topology getTopology() {
        return this.topology;
    }
}

